/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.inappmessage.wrapper;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.groobee.message.R;
import com.groobee.message.inappmessage.ButtonType;
import com.groobee.message.inappmessage.MessageType;
import com.groobee.message.inappmessage.interfaces.InAppMessageScope;
import com.groobee.message.inappmessage.layout.GroobeeLinearLayout;
import com.groobee.message.inappmessage.model.InAppMessage;
import com.groobee.message.inappmessage.wrapper.BindingWrapper;
import java.util.Map;
import javax.inject.Inject;

@InAppMessageScope
public class HtmlModalBindingWrapper
extends BindingWrapper {
    private GroobeeLinearLayout layoutRoot;
    private LinearLayout layoutWebModalContents;
    private WebView webView;
    private Button btnWebModalNegative;
    private Button btnWebModalPositive;
    private View.OnClickListener dismissListener;
    private ViewTreeObserver.OnGlobalLayoutListener layoutListener = new ScrollViewAdjustableListener();

    @Inject
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public HtmlModalBindingWrapper(InAppMessage inAppMessage, LayoutInflater inflater) {
        super(inAppMessage, inflater);
    }

    @Override
    @NonNull
    public ViewTreeObserver.OnGlobalLayoutListener inflate(Map<ButtonType, View.OnClickListener> buttonClickListener, View.OnClickListener dismissClickListener) {
        View root = this.inflater.inflate(R.layout.html_modal, null);
        this.layoutRoot = (GroobeeLinearLayout)root.findViewById(R.id.layoutRoot);
        this.layoutWebModalContents = (LinearLayout)root.findViewById(R.id.layoutWebModalContents);
        this.btnWebModalNegative = (Button)root.findViewById(R.id.btnWebModalNegative);
        this.btnWebModalPositive = (Button)root.findViewById(R.id.btnWebModalPositive);
        this.webView = new WebView(root.getContext().getApplicationContext());
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setDisplayZoomControls(false);
        webSettings.setDomStorageEnabled(true);
        this.webView.setLayerType(2, null);
        this.webView.setBackgroundColor(0);
        this.layoutWebModalContents.addView((View)this.webView);
        if (this.inAppMessage.getMessageType().equals((Object)MessageType.HTML_MODAL)) {
            this.webView.loadData(this.inAppMessage.getBody().getText(), "text/html", "utf-8");
            this.setButtonStyleAppearance(this.btnWebModalPositive, this.inAppMessage.getMessageButton().get((Object)ButtonType.POSITIVE), buttonClickListener.get((Object)ButtonType.POSITIVE));
            this.setButtonStyleAppearance(this.btnWebModalNegative, this.inAppMessage.getMessageButton().get((Object)ButtonType.NEGATIVE), buttonClickListener.get((Object)ButtonType.NEGATIVE));
        }
        this.setDismissListener(dismissClickListener);
        return this.layoutListener;
    }

    @Override
    @NonNull
    public ViewGroup getRootView() {
        return this.layoutRoot;
    }

    @Override
    @NonNull
    public View.OnClickListener getDismissListener() {
        return this.dismissListener;
    }

    private void setDismissListener(View.OnClickListener dismissListener) {
        this.dismissListener = dismissListener;
        this.layoutRoot.onDismissListener(dismissListener);
    }

    public void setLayoutListener(ViewTreeObserver.OnGlobalLayoutListener listener) {
        this.layoutListener = listener;
    }

    public class ScrollViewAdjustableListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        public void onGlobalLayout() {
            HtmlModalBindingWrapper.this.layoutRoot.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }
}

