/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.inappmessage.wrapper;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.groobee.message.R;
import com.groobee.message.inappmessage.ButtonType;
import com.groobee.message.inappmessage.MessageType;
import com.groobee.message.inappmessage.interfaces.InAppMessageScope;
import com.groobee.message.inappmessage.layout.GroobeeLinearLayout;
import com.groobee.message.inappmessage.model.InAppMessage;
import com.groobee.message.inappmessage.wrapper.BindingWrapper;
import java.util.Map;
import javax.inject.Inject;

@InAppMessageScope
public class DialogBindingWrapper
extends BindingWrapper {
    private GroobeeLinearLayout layoutRoot;
    private ImageView imgDialogContents;
    private TextView txtDialogTitle;
    private TextView txtDialogBody;
    private Button btnDialogNegative;
    private Button btnDialogPositive;
    private View.OnClickListener dismissListener;
    private ViewTreeObserver.OnGlobalLayoutListener layoutListener = new ScrollViewAdjustableListener();

    @Inject
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public DialogBindingWrapper(InAppMessage inAppMessage, LayoutInflater inflater) {
        super(inAppMessage, inflater);
    }

    @Override
    @NonNull
    public ViewTreeObserver.OnGlobalLayoutListener inflate(Map<ButtonType, View.OnClickListener> buttonClickListener, View.OnClickListener dismissClickListener) {
        View root = this.inflater.inflate(R.layout.dialog, null);
        this.layoutRoot = (GroobeeLinearLayout)root.findViewById(R.id.layoutRoot);
        this.imgDialogContents = (ImageView)root.findViewById(R.id.imgDialogContents);
        this.txtDialogTitle = (TextView)root.findViewById(R.id.txtDialogTitle);
        this.txtDialogBody = (TextView)root.findViewById(R.id.txtDialogBody);
        this.btnDialogNegative = (Button)root.findViewById(R.id.btnDialogNegative);
        this.btnDialogPositive = (Button)root.findViewById(R.id.btnDialogPositive);
        if (this.inAppMessage.getMessageType().equals((Object)MessageType.DIALOG)) {
            this.setLruImage(this.imgDialogContents, this.inAppMessage.getimageUrl());
            this.setTextStyleAppearance(this.txtDialogTitle, this.inAppMessage.getTitle());
            this.setTextStyleAppearance(this.txtDialogBody, this.inAppMessage.getBody());
            this.setButtonStyleAppearance(this.btnDialogPositive, this.inAppMessage.getMessageButton().get((Object)ButtonType.POSITIVE), buttonClickListener.get((Object)ButtonType.POSITIVE));
            this.setButtonStyleAppearance(this.btnDialogNegative, this.inAppMessage.getMessageButton().get((Object)ButtonType.NEGATIVE), buttonClickListener.get((Object)ButtonType.NEGATIVE));
        }
        this.setDismissListener(dismissClickListener);
        return this.layoutListener;
    }

    @Override
    @NonNull
    public ViewGroup getRootView() {
        return this.layoutRoot;
    }

    @Override
    @NonNull
    public View.OnClickListener getDismissListener() {
        return this.dismissListener;
    }

    private void setDismissListener(View.OnClickListener dismissListener) {
        this.dismissListener = dismissListener;
        this.layoutRoot.onDismissListener(dismissListener);
    }

    public void setLayoutListener(ViewTreeObserver.OnGlobalLayoutListener listener) {
        this.layoutListener = listener;
    }

    public class ScrollViewAdjustableListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        public void onGlobalLayout() {
            DialogBindingWrapper.this.layoutRoot.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }
}

