/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.inappmessage.wrapper;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.groobee.message.Groobee;
import com.groobee.message.inappmessage.ButtonType;
import com.groobee.message.inappmessage.model.InAppMessage;
import com.groobee.message.inappmessage.model.MessageButton;
import com.groobee.message.inappmessage.model.MessageText;
import com.groobee.message.utils.StringUtils;
import java.util.Map;

public abstract class BindingWrapper {
    protected final InAppMessage inAppMessage;
    final LayoutInflater inflater;

    protected BindingWrapper(InAppMessage inAppMessage, LayoutInflater inflater) {
        this.inAppMessage = inAppMessage;
        this.inflater = inflater;
    }

    public abstract ViewTreeObserver.OnGlobalLayoutListener inflate(Map<ButtonType, View.OnClickListener> var1, View.OnClickListener var2);

    protected void setTextStyleAppearance(TextView textView, MessageText messageText) {
        if (!StringUtils.isNullOrBlank(messageText.getText())) {
            textView.setText((CharSequence)messageText.getText());
        }
        if (!StringUtils.isNullOrBlank(messageText.getTextColor())) {
            textView.setTextColor(Color.parseColor((String)messageText.getTextColor()));
        }
        if (messageText.getTextSize() != null && messageText.getTextSize() > 0) {
            textView.setTextSize(2, (float)messageText.getTextSize().intValue());
        }
    }

    protected void setButtonStyleAppearance(Button button, MessageButton messageButton, View.OnClickListener buttonClickListener) {
        if (messageButton != null) {
            if (!StringUtils.isNullOrBlank(messageButton.getText())) {
                String text = messageButton.getText();
                button.setText((CharSequence)text);
                this.setButtonClickListener(button, buttonClickListener);
            }
            if (!StringUtils.isNullOrBlank(messageButton.getTextColor())) {
                button.setTextColor(Color.parseColor((String)messageButton.getTextColor()));
            }
            if (messageButton.getTextSize() != null && messageButton.getTextSize() > 0) {
                button.setTextSize(2, (float)messageButton.getTextSize().intValue());
            }
        }
    }

    protected void setLruImage(ImageView imageView, String imageUrl) {
        if (!StringUtils.isNullOrBlank(imageUrl)) {
            Bitmap bitmap = Groobee.getInstance().getImageLoader().getBitmap(imageUrl);
            imageView.setImageBitmap(bitmap);
        }
    }

    private void setButtonClickListener(Button button, View.OnClickListener buttonClickListener) {
        if (buttonClickListener == null) {
            button.setVisibility(8);
        } else {
            button.setVisibility(0);
            button.setOnClickListener(buttonClickListener);
        }
    }

    @NonNull
    public abstract ViewGroup getRootView();

    public boolean canSwipeToDismiss() {
        return false;
    }

    @Nullable
    public View.OnClickListener getDismissListener() {
        return null;
    }
}

