/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.inappmessage.model;

import android.text.TextUtils;
import androidx.annotation.NonNull;

public class MessageText {
    private String text;
    private String textColor = null;
    private Integer textSize = null;

    public MessageText(@NonNull String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public Integer getTextSize() {
        return this.textSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String text;
        private String textColor;
        private int textSize;

        public Builder setText(String text) {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                this.text = text;
            }
            return this;
        }

        public Builder setTextColor(String textColor) {
            if (!TextUtils.isEmpty((CharSequence)textColor)) {
                this.textColor = textColor;
            }
            return this;
        }

        public Builder setTextSize(Integer textSize) {
            if (textSize != null) {
                this.textSize = textSize;
            }
            return this;
        }

        public MessageText build() {
            return new MessageText(this.text);
        }
    }
}

