/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.inappmessage.model;

import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.groobee.message.inappmessage.ButtonType;

public class MessageButton {
    private Builder builder = null;

    public MessageButton(@NonNull Builder builder) {
        this.builder = builder;
    }

    public String getText() {
        return this.builder.text;
    }

    public String getTextColor() {
        return this.builder.textColor;
    }

    public Integer getTextSize() {
        return this.builder.textSize;
    }

    public String getActivityName() {
        return this.builder.activityName;
    }

    public String getEventUrl() {
        return this.builder.eventUrl;
    }

    public View.OnClickListener getClickListener() {
        return this.builder.onClickListener;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String text;
        private String textColor;
        private int textSize;
        private String eventUrl;
        private String activityName;
        private ButtonType buttonType = ButtonType.POSITIVE;
        private View.OnClickListener onClickListener;

        public Builder setText(String text) {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                this.text = text;
            }
            return this;
        }

        public Builder setTextColor(String textColor) {
            if (!TextUtils.isEmpty((CharSequence)textColor)) {
                this.textColor = textColor;
            }
            return this;
        }

        public Builder setTextSize(Integer textSize) {
            if (textSize != null) {
                this.textSize = textSize;
            }
            return this;
        }

        public Builder setActivityName(String activityName) {
            if (!TextUtils.isEmpty((CharSequence)activityName)) {
                this.activityName = activityName;
            }
            return this;
        }

        public Builder setEventUrl(String eventUrl) {
            if (!TextUtils.isEmpty((CharSequence)eventUrl)) {
                this.eventUrl = eventUrl;
            }
            return this;
        }

        public Builder setOnClickListener(View.OnClickListener onClickListener) {
            if (onClickListener != null) {
                this.onClickListener = onClickListener;
            }
            return this;
        }

        public MessageButton build() {
            return new MessageButton(this);
        }
    }
}

