/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.inappmessage.layout;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.groobee.message.inappmessage.CropType;
import com.groobee.message.utils.LoggerUtils;

@SuppressLint(value={"AppCompatCustomView"})
public class GroobeeImageView
extends ImageView {
    private static final String TAG = LoggerUtils.getClassLogTag(GroobeeImageView.class);
    private Path mClipPath = new Path();
    private RectF mRect = new RectF();
    private float[] mInAppRadii;
    private float mAspectRatio = -1.0f;
    private boolean mSetToHalfParentHeight = false;

    public GroobeeImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setAdjustViewBounds(true);
    }

    public void setCornersRadiiPx(float topLeft, float topRight, float bottomLeft, float bottomRight) {
        this.mInAppRadii = new float[]{topLeft, topLeft, topRight, topRight, bottomLeft, bottomLeft, bottomRight, bottomRight};
    }

    public void setCornersRadiusPx(float cornersRadius) {
        this.setCornersRadiiPx(cornersRadius, cornersRadius, cornersRadius, cornersRadius);
    }

    public void setInAppMessageImageCropType(CropType cropType) {
        if (cropType.equals((Object)CropType.FIT_CENTER)) {
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
        } else if (cropType.equals((Object)CropType.CENTER_CROP)) {
            this.setScaleType(ImageView.ScaleType.CENTER_CROP);
        }
    }

    public void setAspectRatio(float aspectRatio) {
        this.mAspectRatio = aspectRatio;
        this.requestLayout();
    }

    public void setToHalfParentHeight(boolean setToHalfHeight) {
        this.mSetToHalfParentHeight = setToHalfHeight;
        this.requestLayout();
    }

    protected void onDraw(Canvas canvas) {
        this.clipCanvasToPath(canvas, this.getWidth(), this.getHeight());
        super.onDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mAspectRatio != -1.0f && this.getMeasuredHeight() > 0 && this.getMeasuredWidth() > 0) {
            int newWidth = this.getMeasuredWidth();
            int maxHeight = (int)((float)newWidth / this.mAspectRatio);
            int newHeight = Math.min(this.getMeasuredHeight(), maxHeight) + 1;
            this.setMeasuredDimension(newWidth, newHeight);
        } else {
            this.setMeasuredDimension(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
        if (this.mSetToHalfParentHeight) {
            int parentHeight = ((View)this.getParent()).getHeight();
            this.setMeasuredDimension(this.getMeasuredWidth(), (int)((double)parentHeight * 0.5));
        }
    }

    boolean clipCanvasToPath(Canvas canvas, int widthPx, int heightPx) {
        if (this.mInAppRadii != null) {
            try {
                this.mClipPath.reset();
                this.mRect.set(0.0f, 0.0f, (float)widthPx, (float)heightPx);
                this.mClipPath.addRoundRect(this.mRect, this.mInAppRadii, Path.Direction.CW);
                canvas.clipPath(this.mClipPath);
                return true;
            }
            catch (Exception e) {
                LoggerUtils.e(TAG, "Encountered exception while trying to clip in-app message image", e);
                return false;
            }
        }
        return false;
    }

    void setClipPath(Path clipPath) {
        this.mClipPath = clipPath;
    }

    void setRectf(RectF rectF) {
        this.mRect = rectF;
    }

    Path getClipPath() {
        return this.mClipPath;
    }

    RectF getRectf() {
        return this.mRect;
    }

    float[] getInAppRadii() {
        return this.mInAppRadii;
    }
}

