/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.inappmessage.displays;

import android.app.Activity;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.groobee.message.inappmessage.utils.SwipeDismissTouchListener;
import com.groobee.message.inappmessage.wrapper.BindingWrapper;
import com.groobee.message.utils.LoggerUtils;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GroobeeWindowManager {
    private static final String TAG = LoggerUtils.getClassLogTag(GroobeeWindowManager.class);
    private BindingWrapper bindingWrapper;

    @Inject
    GroobeeWindowManager() {
    }

    public void show(@NonNull BindingWrapper bindingWrapper, @NonNull Activity activity, WindowManager.LayoutParams params) {
        if (this.isDisplayed()) {
            LoggerUtils.d(TAG, "Fiam already active. Cannot show new Fiam.");
            return;
        }
        WindowManager windowManager = this.getWindowManager(activity);
        windowManager.addView((View)bindingWrapper.getRootView(), (ViewGroup.LayoutParams)params);
        Log.d((String)"nh", (String)("isFocusable : " + bindingWrapper.getRootView().isFocusable()));
        if (!bindingWrapper.getRootView().isFocusable()) {
            bindingWrapper.getRootView().setFocusable(true);
            bindingWrapper.getRootView().setFocusableInTouchMode(true);
            bindingWrapper.getRootView().requestFocus();
        }
        Log.d((String)"nh", (String)("isFocusable : " + bindingWrapper.getRootView().isFocusable()));
        if (bindingWrapper.canSwipeToDismiss()) {
            SwipeDismissTouchListener listener = this.getSwipeListener(bindingWrapper, windowManager, params);
            bindingWrapper.getRootView().setOnTouchListener((View.OnTouchListener)listener);
        }
        this.bindingWrapper = bindingWrapper;
    }

    public boolean isDisplayed() {
        if (this.bindingWrapper == null) {
            return false;
        }
        return this.bindingWrapper.getRootView().isShown();
    }

    public void dismiss(@NonNull Activity activity) {
        if (this.isDisplayed()) {
            this.getWindowManager(activity).removeViewImmediate((View)this.bindingWrapper.getRootView());
            this.bindingWrapper = null;
        }
    }

    private WindowManager getWindowManager(@NonNull Activity activity) {
        return (WindowManager)activity.getSystemService("window");
    }

    private SwipeDismissTouchListener getSwipeListener(final BindingWrapper bindingWrapper, final WindowManager windowManager, final WindowManager.LayoutParams layoutParams) {
        SwipeDismissTouchListener.DismissCallbacks callbacks = new SwipeDismissTouchListener.DismissCallbacks(){

            @Override
            public boolean canDismiss(Object token) {
                return true;
            }

            @Override
            public void onDismiss(View view, Object token) {
                if (bindingWrapper.getDismissListener() != null) {
                    bindingWrapper.getDismissListener().onClick(view);
                }
            }
        };
        if (layoutParams.width == -1) {
            return new SwipeDismissTouchListener((View)bindingWrapper.getRootView(), null, callbacks);
        }
        return new SwipeDismissTouchListener((View)bindingWrapper.getRootView(), null, callbacks){

            @Override
            protected float getTranslationX() {
                return layoutParams.x;
            }

            @Override
            protected void setTranslationX(float translationX) {
                layoutParams.x = (int)translationX;
                windowManager.updateViewLayout((View)bindingWrapper.getRootView(), (ViewGroup.LayoutParams)layoutParams);
            }
        };
    }
}

