/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.inappmessage.displays;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.browser.customtabs.CustomTabsIntent;
import com.groobee.message.inappmessage.ButtonType;
import com.groobee.message.inappmessage.GroobeeActivityLifecycleCallbacks;
import com.groobee.message.inappmessage.MessageType;
import com.groobee.message.inappmessage.displays.GroobeeWindowManager;
import com.groobee.message.inappmessage.interfaces.DialogListener;
import com.groobee.message.inappmessage.interfaces.GroobeeInAppMessagingDisplayCallbacks;
import com.groobee.message.inappmessage.interfaces.InAppMessageScope;
import com.groobee.message.inappmessage.model.InAppMessage;
import com.groobee.message.inappmessage.model.MessageButton;
import com.groobee.message.inappmessage.utils.AnimatorUtils;
import com.groobee.message.inappmessage.utils.RenewableTimer;
import com.groobee.message.inappmessage.wrapper.BindingWrapper;
import com.groobee.message.inappmessage.wrapper.factorys.BindingWrapperFactory;
import com.groobee.message.utils.IntentUtils;
import com.groobee.message.utils.LoggerUtils;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

@Keep
@InAppMessageScope
public class GroobeeInAppMessageDisplay
extends GroobeeActivityLifecycleCallbacks {
    private static final String TAG = LoggerUtils.getClassLogTag(GroobeeInAppMessageDisplay.class);
    static final long IMPRESSION_THRESHOLD_MILLIS = 5000L;
    static final long DISMISS_THRESHOLD_MILLIS = 20000L;
    static final long INTERVAL_MILLIS = 1000L;
    private static final int DEFAULT_TYPE = 1003;
    public static int DISABLED_BG_FLAG = 327938;
    public static int DISMISSIBLE_DIALOG_FLAG = 327970;
    private int ENABLED_BG_FLAG = 65824;
    private final RenewableTimer impressionTimer = new RenewableTimer();
    private final RenewableTimer autoDismissTimer = new RenewableTimer();
    private final GroobeeWindowManager windowManager = new GroobeeWindowManager();
    private BindingWrapperFactory bindingWrapperFactory;
    private final AnimatorUtils animator = new AnimatorUtils();
    private DialogListener dialogListener;
    private InAppMessage inAppMessage;
    private GroobeeInAppMessagingDisplayCallbacks callbacks;
    private BindingWrapper bindingWrapper;

    @Keep
    public static GroobeeInAppMessageDisplay getInstance() {
        return LazyHolder.INSTANCE;
    }

    @Inject
    public GroobeeInAppMessageDisplay() {
    }

    @Override
    public void onActivityStarted(Activity activity) {
        super.onActivityStarted(activity);
    }

    @Override
    public void onActivityPaused(Activity activity) {
        LoggerUtils.d(TAG, "onActivityPaused");
        this.removeDisplayed(activity);
        this.notifyDismiss();
        super.onActivityPaused(activity);
    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        LoggerUtils.d(TAG, "onActivityDestroyed");
        this.removeDisplayed(activity);
        this.notifyDismiss();
        super.onActivityDestroyed(activity);
    }

    @Override
    public void onActivityResumed(Activity activity) {
        if (this.inAppMessage != null) {
            LoggerUtils.d(TAG, "showActive");
            this.showActive(activity);
        }
        super.onActivityResumed(activity);
    }

    public void testMessage(Activity activity, InAppMessage inAppMessage, GroobeeInAppMessagingDisplayCallbacks callbacks) {
        this.inAppMessage = inAppMessage;
        this.callbacks = callbacks;
        this.showActive(activity);
    }

    public void showMessagePopup(Activity activity, InAppMessage inAppMessage, GroobeeInAppMessagingDisplayCallbacks callbacks) {
        this.inAppMessage = inAppMessage;
        this.callbacks = callbacks;
        this.showActive(activity);
    }

    private void showActive(final @NonNull Activity activity) {
        if (this.inAppMessage == null) {
            LoggerUtils.e(TAG, "No active message found to render");
            return;
        }
        this.notifyTrigger();
        if (this.bindingWrapperFactory == null) {
            this.bindingWrapperFactory = new BindingWrapperFactory(activity.getApplication());
        }
        final MessageType messageType = this.inAppMessage.getMessageType();
        switch (messageType) {
            case DIALOG: {
                this.bindingWrapper = this.bindingWrapperFactory.createDialogBindingWrapper(this.inAppMessage);
                break;
            }
            case HTML_MODAL: {
                this.bindingWrapper = this.bindingWrapperFactory.createHtmlModalBindingWrapper(this.inAppMessage);
                break;
            }
            default: {
                LoggerUtils.e(TAG, "No bindings found for this message type");
                return;
            }
        }
        activity.findViewById(0x1020002).post(new Runnable(){

            @Override
            public void run() {
                GroobeeInAppMessageDisplay.this.inflateBinding(activity, GroobeeInAppMessageDisplay.this.bindingWrapper, messageType);
            }
        });
    }

    private void dismiss(Activity activity) {
        LoggerUtils.d(TAG, "Dismissing");
        this.notifyDismiss();
        this.removeDisplayed(activity);
        this.inAppMessage = null;
        this.callbacks = null;
    }

    private void removeDisplayed(Activity activity) {
        if (this.windowManager.isDisplayed()) {
            LoggerUtils.d(TAG, "removeDisplayed");
            this.windowManager.dismiss(activity);
            this.cancelTimers();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void inflateBinding(final Activity activity, final BindingWrapper bindingWrapper, final MessageType messageType) {
        View.OnClickListener dismissListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (GroobeeInAppMessageDisplay.this.callbacks != null) {
                    GroobeeInAppMessageDisplay.this.callbacks.messageDismissed(GroobeeInAppMessagingDisplayCallbacks.InAppMessagingDismissType.CLICK);
                }
                GroobeeInAppMessageDisplay.this.dismiss(activity);
            }
        };
        HashMap<ButtonType, View.OnClickListener> actionListeners = new HashMap<ButtonType, View.OnClickListener>();
        final Map<ButtonType, MessageButton> mapMessage = this.inAppMessage.getMessageButton();
        for (final ButtonType buttonType : mapMessage.keySet()) {
            Object actionListener;
            if (buttonType != null && !TextUtils.isEmpty((CharSequence)mapMessage.get((Object)buttonType).getEventUrl())) {
                actionListener = new View.OnClickListener(){

                    public void onClick(View v) {
                        if (GroobeeInAppMessageDisplay.this.callbacks != null) {
                            GroobeeInAppMessageDisplay.this.callbacks.messageClicked((MessageButton)mapMessage.get((Object)buttonType));
                        }
                        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().setShowTitle(true).build();
                        customTabsIntent.launchUrl((Context)activity, Uri.parse((String)((MessageButton)mapMessage.get((Object)buttonType)).getEventUrl()));
                        GroobeeInAppMessageDisplay.this.notifyClick();
                        GroobeeInAppMessageDisplay.this.removeDisplayed(activity);
                        GroobeeInAppMessageDisplay.this.inAppMessage = null;
                        GroobeeInAppMessageDisplay.this.callbacks = null;
                    }
                };
            } else if (buttonType != null && mapMessage.get((Object)buttonType).getClickListener() != null) {
                actionListener = new View.OnClickListener(){

                    public void onClick(View v) {
                        if (GroobeeInAppMessageDisplay.this.callbacks != null) {
                            GroobeeInAppMessageDisplay.this.callbacks.messageClicked((MessageButton)mapMessage.get((Object)buttonType));
                        }
                        ((MessageButton)mapMessage.get((Object)buttonType)).getClickListener().onClick(v);
                        GroobeeInAppMessageDisplay.this.notifyClick();
                        GroobeeInAppMessageDisplay.this.removeDisplayed(activity);
                        GroobeeInAppMessageDisplay.this.inAppMessage = null;
                        GroobeeInAppMessageDisplay.this.callbacks = null;
                    }
                };
            } else if (buttonType != null && !TextUtils.isEmpty((CharSequence)mapMessage.get((Object)buttonType).getActivityName())) {
                actionListener = new View.OnClickListener(){

                    public void onClick(View v) {
                        if (GroobeeInAppMessageDisplay.this.callbacks != null) {
                            GroobeeInAppMessageDisplay.this.callbacks.messageClicked((MessageButton)mapMessage.get((Object)buttonType));
                        }
                        GroobeeInAppMessageDisplay.this.notifyClick();
                        GroobeeInAppMessageDisplay.this.removeDisplayed(activity);
                        GroobeeInAppMessageDisplay.this.inAppMessage = null;
                        GroobeeInAppMessageDisplay.this.callbacks = null;
                        Intent it = IntentUtils.setActivity((Context)activity, ((MessageButton)mapMessage.get((Object)buttonType)).getActivityName(), new Bundle());
                        activity.startActivity(it);
                    }
                };
            } else {
                LoggerUtils.e(TAG, "No action url found for action.");
                actionListener = dismissListener;
            }
            actionListeners.put(buttonType, (View.OnClickListener)actionListener);
        }
        ViewTreeObserver.OnGlobalLayoutListener layoutListener = bindingWrapper.inflate(actionListeners, dismissListener);
        if (layoutListener != null) {
            bindingWrapper.getRootView().getViewTreeObserver().addOnGlobalLayoutListener(layoutListener);
        }
        bindingWrapper.getRootView().setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 4) {
                    if (GroobeeInAppMessageDisplay.this.callbacks != null) {
                        GroobeeInAppMessageDisplay.this.callbacks.messageDismissed(GroobeeInAppMessagingDisplayCallbacks.InAppMessagingDismissType.UNKNOWN_DISMISS_TYPE);
                    }
                    GroobeeInAppMessageDisplay.this.dismiss(activity);
                    return true;
                }
                return false;
            }
        });
        this.impressionTimer.start(new RenewableTimer.Callback(){

            @Override
            public void onFinish() {
                if (GroobeeInAppMessageDisplay.this.inAppMessage != null && GroobeeInAppMessageDisplay.this.callbacks != null) {
                    LoggerUtils.i(TAG, "Impression timer onFinish for: " + GroobeeInAppMessageDisplay.this.inAppMessage.getTitle().getText());
                    GroobeeInAppMessageDisplay.this.callbacks.impressionDetected();
                }
            }
        }, 5000L, 1000L);
        if (this.inAppMessage.getMessageType().equals((Object)MessageType.HTML_MODAL)) {
            this.autoDismissTimer.start(new RenewableTimer.Callback(){

                @Override
                public void onFinish() {
                    if (GroobeeInAppMessageDisplay.this.inAppMessage != null && GroobeeInAppMessageDisplay.this.callbacks != null) {
                        GroobeeInAppMessageDisplay.this.callbacks.messageDismissed(GroobeeInAppMessagingDisplayCallbacks.InAppMessagingDismissType.AUTO);
                    }
                    GroobeeInAppMessageDisplay.this.dismiss(activity);
                }
            }, 20000L, 1000L);
        }
        Handler mainLooperHandler = new Handler(activity.getMainLooper());
        mainLooperHandler.post(new Runnable(){

            @Override
            public void run() {
                GroobeeInAppMessageDisplay.this.windowManager.show(bindingWrapper, activity, GroobeeInAppMessageDisplay.this.getLayoutParams(messageType));
            }
        });
    }

    private void cancelTimers() {
        this.impressionTimer.cancel();
        this.autoDismissTimer.cancel();
    }

    private void notifyTrigger() {
        if (this.dialogListener != null) {
            this.dialogListener.onTrigger();
        }
    }

    private void notifyClick() {
        if (this.dialogListener != null) {
            this.dialogListener.onClick();
        }
    }

    private void notifyDismiss() {
        if (this.dialogListener != null) {
            this.dialogListener.onDismiss();
        }
    }

    private WindowManager.LayoutParams getLayoutParams(@NonNull MessageType messageType) {
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        switch (messageType) {
            case DIALOG: 
            case HTML_MODAL: {
                layoutParams.width = -1;
                layoutParams.height = -2;
                layoutParams.type = 1003;
                layoutParams.flags = DISABLED_BG_FLAG;
                layoutParams.format = -3;
            }
        }
        layoutParams.dimAmount = 0.3f;
        layoutParams.windowAnimations = 0;
        return layoutParams;
    }

    private static class LazyHolder {
        private static final GroobeeInAppMessageDisplay INSTANCE = new GroobeeInAppMessageDisplay();

        private LazyHolder() {
        }
    }
}

