/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.common.thread;

import com.groobee.message.utils.LoggerUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class WorkingThreadPool
extends ThreadPoolExecutor {
    private static final String TAG = LoggerUtils.getClassLogTag(WorkingThreadPool.class);
    private List<Runnable> copyOnWriteArrayList = new CopyOnWriteArrayList<Runnable>();
    private Map<Runnable, Thread> map = new HashMap<Runnable, Thread>();
    private String id;

    public WorkingThreadPool(String id2, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.id = id2;
        this.setRejectedExecutionHandler(new HandlerRejectExecution());
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.copyOnWriteArrayList.add(r);
        this.map.put(r, t);
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.copyOnWriteArrayList.remove(r);
        this.map.remove(r);
        super.afterExecute(r, t);
    }

    private String getWorkingState() {
        try {
            if (this.getActiveCount() != this.copyOnWriteArrayList.size()) {
                LoggerUtils.d(TAG, "Running task count does not match ThreadPoolExecutor active count. \nrunningTasks.size(): " + this.copyOnWriteArrayList.size() + " getActiveCount(): " + this.getActiveCount() + " ID: " + this.id);
                return null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("Running Tasks Size ");
            builder.append(this.copyOnWriteArrayList.size());
            builder.append(" Active thread dumps => \n");
            for (Thread thread : this.map.values()) {
                try {
                    StackTraceElement[] stackTraceElements = thread.getStackTrace();
                    builder.append(this.parseStackTrace(stackTraceElements) + "\n");
                }
                catch (Exception ex) {
                    LoggerUtils.e(TAG, "Failed to create description for active thread: " + thread + " ID: " + this.id, ex);
                }
            }
            return builder.toString();
        }
        catch (Exception e) {
            LoggerUtils.e(TAG, "Failed to create running tasks description. ID: " + this.id, e);
            return null;
        }
    }

    private String parseStackTrace(StackTraceElement[] stackTraceElements) {
        if (stackTraceElements.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int size = stackTraceElements.length;
        for (int i = 0; i < size; ++i) {
            builder.append("\n => ");
            builder.append(stackTraceElements[i]);
        }
        return builder.toString();
    }

    class HandlerRejectExecution
    implements RejectedExecutionHandler {
        HandlerRejectExecution() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            LoggerUtils.d(TAG, "Rejected execution on runnable: " + r + " . ID: " + WorkingThreadPool.this.id);
            if (!executor.isShutdown() && !executor.isTerminating()) {
                String workingState = WorkingThreadPool.this.getWorkingState();
                try {
                    Runnable runnable;
                    if (!WorkingThreadPool.this.copyOnWriteArrayList.isEmpty()) {
                        runnable = (Runnable)WorkingThreadPool.this.copyOnWriteArrayList.get(0);
                        if (runnable instanceof Future) {
                            ((Future)((Object)runnable)).cancel(true);
                        } else {
                            Thread var5 = (Thread)WorkingThreadPool.this.map.get(runnable);
                            if (var5 != null) {
                                var5.interrupt();
                            }
                        }
                        WorkingThreadPool.this.copyOnWriteArrayList.remove(runnable);
                        WorkingThreadPool.this.map.remove(runnable);
                    }
                    if ((runnable = (Runnable)executor.getQueue().poll()) != null) {
                        LoggerUtils.v(TAG, "Running head of queue on caller thread: " + runnable + " . ID: " + WorkingThreadPool.this.id);
                        ExecutorService var7 = Executors.newSingleThreadExecutor();
                        var7.invokeAll(Collections.singletonList(Executors.callable(runnable)), 200L, TimeUnit.MILLISECONDS);
                    }
                    LoggerUtils.v(TAG, "Re-adding rejected task to queue: " + r + " . ID: " + WorkingThreadPool.this.id);
                    executor.execute(r);
                }
                catch (Exception var6) {
                    LoggerUtils.d(TAG, "Caught exception in rejected execution handler for incoming task: " + r + " . Running tasks description: " + workingState, var6);
                }
                if (workingState != null) {
                    LoggerUtils.w(TAG, "Handled rejected execution on incoming task: " + workingState);
                }
            } else {
                LoggerUtils.i(TAG, "ThreadPoolExecutor is shutdown. Dropping rejected task. ID: " + WorkingThreadPool.this.id);
            }
        }
    }
}

