/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.common.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkingThreadFactory
implements ThreadFactory {
    private final String workingThreadName;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final AtomicInteger atomicInteger = new AtomicInteger();

    public WorkingThreadFactory() {
        this.workingThreadName = WorkingThreadFactory.class.getSimpleName();
    }

    public WorkingThreadFactory(String workingThreadName) {
        this.workingThreadName = workingThreadName;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    public Thread newThread(Runnable r) {
        if (this.uncaughtExceptionHandler == null) {
            throw new IllegalStateException("NullPointerException UncaughtExceptionHandler. You must call setUncaughtExceptionHandler before creating a new thread");
        }
        Thread thread = new Thread(r, this.workingThreadName + " #" + this.atomicInteger.getAndIncrement());
        thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        return thread;
    }
}

