/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message;

import android.app.Notification;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.core.app.NotificationManagerCompat;
import com.groobee.message.GroobeeConfig;
import com.groobee.message.providers.GroobeeConfigProvider;
import com.groobee.message.push.interfaces.InterfaceGroobeeNotificationFactory;
import com.groobee.message.push.utils.GroobeeNotificationActionUtils;
import com.groobee.message.push.utils.GroobeeNotificationUtils;
import com.groobee.message.utils.LoggerUtils;

public class GroobeeFirebaseReceiver
extends BroadcastReceiver {
    private static final String TAG = LoggerUtils.getClassLogTag(GroobeeConfig.class);
    private static final String FCM_RECEIVE_INTENT_ACTION = "com.google.android.c2dm.intent.RECEIVE";
    private static final String FCM_MESSAGE_TYPE_KEY = "message_type";
    private static final String FCM_DELETED_MESSAGES_KEY = "deleted_messages";
    private static final String FCM_NUMBER_OF_MESSAGES_DELETED_KEY = "total_deleted";
    protected static final String FIREBASE_MESSAGING_SERVICE_ROUTING_ACTION = "firebase_messaging_service_routing_action";

    public void onReceive(Context context, Intent intent) {
        LoggerUtils.i(TAG, "Received broadcast message. Message: " + intent.toString());
        String action = intent.getAction();
        if (FCM_RECEIVE_INTENT_ACTION.equals(action) || FIREBASE_MESSAGING_SERVICE_ROUTING_ACTION.equals(action)) {
            this.handleReceiveMessage(context, intent);
        } else if ("com.groobee.action.CANCEL_NOTIFICATION".equals(action)) {
            GroobeeNotificationUtils.handleCancelNotificationAction(context, intent);
        } else if ("com.groobee.action.PUSH_ACTION_CLICKED".equals(action)) {
            GroobeeNotificationActionUtils.handleNotificationActionClicked(context, intent);
        } else if ("com.groobee.action.PUSH_CLICKED".equals(action)) {
            GroobeeNotificationUtils.handleNotificationOpened(context, intent);
        } else if ("com.groobee.action.PUSH_DELETED".equals(action)) {
            GroobeeNotificationUtils.handleNotificationDeleted(context, intent);
        } else {
            LoggerUtils.w(TAG, "The FCM receiver received a message not sent from sdk. Ignoring the message.");
        }
    }

    public boolean handleReceiveMessage(Context context, Intent intent) {
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)context);
        String messageType = intent.getStringExtra(FCM_MESSAGE_TYPE_KEY);
        if (FCM_DELETED_MESSAGES_KEY.equals(messageType)) {
            int totalDeleted = intent.getIntExtra(FCM_NUMBER_OF_MESSAGES_DELETED_KEY, -1);
            if (totalDeleted == -1) {
                LoggerUtils.e(TAG, "Unable to parse FCM message. Intent: " + intent.toString());
            } else {
                LoggerUtils.i(TAG, "FCM deleted " + totalDeleted + " messages.");
            }
            return false;
        }
        Bundle fcmExtras = intent.getExtras();
        LoggerUtils.i(TAG, "Push message payload received: " + fcmExtras);
        Bundle extras = new Bundle();
        int notificationId = GroobeeNotificationUtils.getNotificationId(fcmExtras);
        GroobeeConfigProvider groobeeConfigProvider = new GroobeeConfigProvider(context);
        InterfaceGroobeeNotificationFactory interfaceGroobeeNotificationFactory = GroobeeNotificationUtils.getActiveNotificationFactory();
        Notification notification = interfaceGroobeeNotificationFactory.createNotification(groobeeConfigProvider, context, fcmExtras, extras);
        notificationManager.notify("push_notification_tag", notificationId, notification);
        return true;
    }
}

