/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.groobee.message.GroobeeFirebaseReceiver;
import com.groobee.message.utils.LoggerUtils;
import java.util.Map;

public class GroobeeFirebaseMessagingService
extends FirebaseMessagingService {
    private static final String TAG = LoggerUtils.getClassLogTag(GroobeeFirebaseMessagingService.class);
    private static final GroobeeFirebaseReceiver groobeeFirebaseReceiver = new GroobeeFirebaseReceiver();

    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        GroobeeFirebaseMessagingService.handleRemoteMessage((Context)this, remoteMessage);
    }

    public static boolean handleRemoteMessage(Context context, RemoteMessage remoteMessage) {
        if (remoteMessage == null) {
            LoggerUtils.w(TAG, "Remote message from FCM was null.");
            return false;
        }
        if (remoteMessage.getData() == null) {
            LoggerUtils.w(TAG, "Remote message data from FCM was null.");
            return false;
        }
        Map remoteMessageData = remoteMessage.getData();
        LoggerUtils.i(TAG, "Got remote message from FCM: " + remoteMessageData);
        Object notification = null;
        Intent pushIntent = new Intent("firebase_messaging_service_routing_action");
        Bundle bundle = new Bundle();
        for (Map.Entry entry : remoteMessageData.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            LoggerUtils.v(TAG, "Adding bundle item from FCM remote data with key: " + key + " and value: " + value);
            bundle.putString(key, value);
        }
        pushIntent.putExtras(bundle);
        groobeeFirebaseReceiver.onReceive(context, pushIntent);
        return true;
    }
}

