/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message;

import com.groobee.message.utils.LoggerUtils;
import com.groobee.message.utils.StringUtils;

public class GroobeeConfig {
    private static final String TAG = LoggerUtils.getClassLogTag(GroobeeConfig.class);
    private static Builder builder = null;

    private GroobeeConfig(Builder builder) {
        GroobeeConfig.builder = builder;
    }

    public String getApiKey() {
        return Builder.apiKey;
    }

    public Boolean getHandlePushDeepLinks() {
        return builder.handlePushDeepLinks;
    }

    public Boolean getPushMoveActivityEnabled() {
        return builder.moveActivityEnabled;
    }

    public String getPushMoveActivityClassName() {
        return builder.ActivityClass;
    }

    public String getSmallNotificationIcon() {
        return builder.smallNotificationIconName;
    }

    public String getLargeNotificationIcon() {
        return builder.largeNotificationIconName;
    }

    public static class Builder {
        public static String apiKey = null;
        private boolean handlePushDeepLinks;
        private boolean moveActivityEnabled;
        private String ActivityClass;
        private String smallNotificationIconName;
        private String largeNotificationIconName;

        public GroobeeConfig build() {
            return new GroobeeConfig(this);
        }

        public Builder setApiKey(String apiKey) {
            if (!StringUtils.isNullOrBlank(apiKey)) {
                Builder.apiKey = apiKey;
            } else {
                LoggerUtils.e(TAG, "Api Key is Empty. Please register api key.");
            }
            return this;
        }

        public Builder setHandlePushDeepLinks(boolean handlePushDeepLinks) {
            this.handlePushDeepLinks = handlePushDeepLinks;
            return this;
        }

        public Builder setPushMoveActivityEnabled(boolean moveActivityEnabled) {
            this.moveActivityEnabled = moveActivityEnabled;
            return this;
        }

        public Builder setPushMoveActivityClassName(Class ActivityClass) {
            this.ActivityClass = ActivityClass.getName();
            return this;
        }

        public Builder setSmallNotificationIcon(String smallNotificationIconName) {
            this.smallNotificationIconName = smallNotificationIconName;
            return this;
        }

        public Builder setLargeNotificationIcon(String largeNotificationIconName) {
            this.largeNotificationIconName = largeNotificationIconName;
            return this;
        }
    }
}

