/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import androidx.annotation.NonNull;
import com.groobee.message.GroobeeConfig;
import com.groobee.message.common.GroobeeImageLoader;
import com.groobee.message.common.thread.HandlerUncaughtException;
import com.groobee.message.common.thread.WorkingThreadFactory;
import com.groobee.message.common.thread.WorkingThreadSmall;
import com.groobee.message.inappmessage.ButtonType;
import com.groobee.message.inappmessage.MessageType;
import com.groobee.message.inappmessage.displays.GroobeeInAppMessageDisplay;
import com.groobee.message.inappmessage.model.InAppMessage;
import com.groobee.message.inappmessage.model.MessageButton;
import com.groobee.message.inappmessage.model.MessageText;
import com.groobee.message.inappmessage.utils.AnimatorUtils;
import com.groobee.message.inappmessage.utils.RenewableTimer;
import com.groobee.message.inappmessage.wrapper.factorys.BindingWrapperFactory;
import com.groobee.message.providers.GroobeeConfigProvider;
import com.groobee.message.providers.RuntimeConfigProvider;
import com.groobee.message.push.interfaces.InterfaceGroobeeNotificationFactory;
import com.groobee.message.utils.LoggerUtils;
import com.groobee.message.utils.StringUtils;
import java.util.HashMap;
import java.util.concurrent.Executor;
import javax.inject.Singleton;

@Singleton
public class Groobee {
    private static final String TAG = LoggerUtils.getClassLogTag(Groobee.class);
    private static volatile InterfaceGroobeeNotificationFactory interfaceGroobeeNotificationFactory;
    private Context context;
    private GroobeeImageLoader groobeeImageLoader;
    private HandlerUncaughtException handlerUncaughtException = new HandlerUncaughtException();
    private WorkingThreadSmall workingThreadSmall;
    private RenewableTimer impressionTimer;
    private RenewableTimer autoDismissTimer;
    private BindingWrapperFactory bindingWrapperFactory;
    private AnimatorUtils animatorUtils;
    private GroobeeConfigProvider groobeeConfigProvider;

    public static Groobee getInstance() {
        return LazyHolder.INSTANCE;
    }

    public Groobee() {
        WorkingThreadFactory workingThreadFactory = new WorkingThreadFactory("Groobee-Working-Pool-Thread");
        workingThreadFactory.setUncaughtExceptionHandler(this.handlerUncaughtException);
        this.workingThreadSmall = new WorkingThreadSmall("identifier", workingThreadFactory);
        this.impressionTimer = new RenewableTimer();
        this.autoDismissTimer = new RenewableTimer();
        this.animatorUtils = new AnimatorUtils();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean configure(Context context, GroobeeConfig config) {
        LoggerUtils.d(TAG, "configure() called with configuration: " + config);
        if (Groobee.getInstance() == null) {
            Class<Groobee> clazz = Groobee.class;
            // MONITORENTER : com.groobee.message.Groobee.class
            if (Groobee.getInstance() == null) {
                RuntimeConfigProvider runtimeConfigProvider = new RuntimeConfigProvider(context);
                if (config != null) {
                    runtimeConfigProvider.setRuntimeConfig(config);
                    // MONITOREXIT : clazz
                    return true;
                }
                runtimeConfigProvider.clean();
                // MONITOREXIT : clazz
                return true;
            }
            // MONITOREXIT : clazz
        }
        Groobee.getInstance().context = context.getApplicationContext();
        Groobee.getInstance().groobeeImageLoader = new GroobeeImageLoader(context);
        Groobee.getInstance().groobeeConfigProvider = new GroobeeConfigProvider(context);
        return false;
    }

    public GroobeeInAppMessageDisplay getActivityLifecycleCallbacks() {
        return GroobeeInAppMessageDisplay.getInstance();
    }

    public GroobeeImageLoader getImageLoader() {
        if (this.groobeeImageLoader == null) {
            LoggerUtils.d(TAG, "The Image Loader was null. Creating a new Image Loader and returning it.");
            this.groobeeImageLoader = new GroobeeImageLoader(this.context);
        }
        return this.groobeeImageLoader;
    }

    public static void setCustomGroobeeNotificationFactory(InterfaceGroobeeNotificationFactory customGroobeeNotificationFactory) {
        LoggerUtils.d(TAG, "Custom Braze notification factory set");
        interfaceGroobeeNotificationFactory = customGroobeeNotificationFactory;
    }

    public static InterfaceGroobeeNotificationFactory getCustomGroobeeNotificationFactory() {
        return interfaceGroobeeNotificationFactory;
    }

    public void logPushNotificationActionClicked(String campaignId, String actionId, String actionType) {
        LoggerUtils.d(TAG, "call method logPushNotificationActionClicked");
    }

    public void logPushNotificationOpened(final Intent intent) {
        LoggerUtils.d(TAG, "call method logPushNotificationOpened");
        this.workingThreadSmall.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (intent.hasExtra("cid")) {
                        String cid = intent.getStringExtra("cid");
                        if (!StringUtils.isNullOrBlank(cid)) {
                            LoggerUtils.i(TAG, "Logging push click to notification. Campaign Id: " + cid);
                        } else {
                            LoggerUtils.i(TAG, "Not Found campaign Id with this notification");
                        }
                    }
                }
                catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging push notification", e);
                }
            }
        });
    }

    public void logPushDeliveryEvent(String campaignId) {
        LoggerUtils.d(TAG, "call method logPushDeliveryEvent");
    }

    public void showDialog(Activity activity) {
        LoggerUtils.d(TAG, "call showDialog");
        this.workingThreadSmall.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageText title = new MessageText.Builder().setText("Title TEST!!").build();
                    MessageText body = new MessageText.Builder().setText("Body TEST!!").build();
                    MessageButton messageButton1 = new MessageButton.Builder().setText("Button1").setEventUrl("https://naver.com").build();
                    HashMap<ButtonType, MessageButton> messageButton = new HashMap<ButtonType, MessageButton>();
                    messageButton.put(ButtonType.POSITIVE, messageButton1);
                    HashMap<String, String> data = new HashMap<String, String>();
                    InAppMessage inAppMessage = new InAppMessage(title, body, null, messageButton, data, MessageType.DIALOG);
                }
                catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging push notification", e);
                }
            }
        });
    }

    public void showDialog(final Activity activity, final View.OnClickListener onClickListener) {
        LoggerUtils.d(TAG, "call showDialog");
        this.workingThreadSmall.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageText title = new MessageText.Builder().setText("Title TEST!!").build();
                    MessageText body = new MessageText.Builder().setText("Body TEST!! " + Groobee.this.groobeeConfigProvider.getGroobeeApiKey()).build();
                    MessageButton messageButton1 = new MessageButton.Builder().setText("Button1").setEventUrl("https://naver.com").build();
                    MessageButton messageButton2 = new MessageButton.Builder().setText("Button2").setOnClickListener(onClickListener).build();
                    HashMap<ButtonType, MessageButton> messageButton = new HashMap<ButtonType, MessageButton>();
                    messageButton.put(ButtonType.NEGATIVE, messageButton2);
                    messageButton.put(ButtonType.POSITIVE, messageButton1);
                    HashMap<String, String> data = new HashMap<String, String>();
                    InAppMessage inAppMessage = new InAppMessage(title, body, "https://static.hubzum.zumst.com/hubzum/2018/03/21/10/b4af8da309e846cc87927e8e6f939b23.jpg", messageButton, data, MessageType.DIALOG);
                    GroobeeInAppMessageDisplay.getInstance().showMessagePopup(activity, inAppMessage, null);
                }
                catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging push notification", e);
                }
            }
        });
    }

    private static class UiExecutor
    implements Executor {
        private static final Handler HANDLER = new Handler(Looper.getMainLooper());

        private UiExecutor() {
        }

        @Override
        public void execute(@NonNull Runnable command) {
            HANDLER.post(command);
        }
    }

    private static class LazyHolder {
        private static final Groobee INSTANCE = new Groobee();

        private LazyHolder() {
        }
    }
}

