package com.groobee.message.models;

import com.google.gson.annotations.SerializedName;

import java.util.List;
import java.util.Map;

import lombok.Builder;
import lombok.Data;

@Data
@Builder
public class RequestParams {

    @SerializedName("serviceKey")
    private String serviceKey;

    @SerializedName("deviceType")
    private String deviceType;

    @SerializedName("deviceCd")
    private String deviceCd;

    @SerializedName("cookieId")
    private String cookieId;

    @SerializedName("userId")
    private String userId;

    @SerializedName("actionCd")
    private String actionCd;

    @SerializedName("memberId")
    private String memberId;

    @SerializedName("searchKwd")
    private String searchKwd;

    @SerializedName("orderNo")
    private String orderNo;

    @SerializedName("appData")
    private AppData appData;

    @SerializedName("memberData")
    private MemberData memberData;

    @SerializedName("goods")
    private List<Goods> goods;

    @SerializedName("category")
    private Category category;

    @SerializedName("customData")
    private Map<String, Object> customData;
}
