package com.groobee.message.models;

import com.google.gson.annotations.SerializedName;

import java.util.List;

import lombok.Builder;
import lombok.Data;

@Data
@Builder
public class AppData {

    @SerializedName("packageName")
    private String packageName;

    @SerializedName("agreedType")
    private String agreedType;

    @SerializedName("token")
    private String token;

    @SerializedName("adid")
    private String adid;

    @SerializedName("appName")
    private String appName;

    @SerializedName("appVersion")
    private String appVersion;

    @SerializedName("firmwareName")
    private String firmwareName;

    @SerializedName("deviceOS")
    private String deviceOS;

    @SerializedName("screenAct")
    private String screenAct;

    @SerializedName("screenData")
    private String screenData;

    @SerializedName("screenName")
    private String screenName;

    @SerializedName("deviceSDK")
    private int deviceSDK;

    @SerializedName("agreedAP")
    private Boolean agreedAP;

    @SerializedName("agreedAA")
    private Boolean agreedAA;

    @SerializedName("agreedAN")
    private Boolean agreedAN;

    @SerializedName("pushOpened")
    private Boolean pushOpened;

    @SerializedName("terMinated")
    private Boolean terMinated;

    @SerializedName("latitude")
    private Double latitude;

    @SerializedName("longitude")
    private Double longitude;

    @SerializedName("campaignKeyList")
    private List<CampaignKeyData> campaignKeyList;

    @SerializedName("touchInfo")
    private List<Object> touchInfo;
}
