package com.groobee.message.common;

import android.app.Activity;

import com.groobee.message.Groobee;
import com.groobee.message.models.AppData;
import com.groobee.message.models.CampaignKeyData;
import com.groobee.message.models.Category;
import com.groobee.message.models.Goods;
import com.groobee.message.models.MemberData;
import com.groobee.message.models.RequestParams;

import java.util.List;
import java.util.Map;

public class ModelBuilder {
    public static RequestParams authServiceKey(String serviceKey, String cookieId, String userId, String packageName, String memberId) {
        if (userId == null || userId.isEmpty())
            userId = cookieId;

        AppData appData = AppData.builder().packageName(packageName).build();
        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceType("AS")
                .cookieId(cookieId)
                .userId(userId)
                .appData(appData);

        if (memberId != null && !memberId.isEmpty())
            requestParamsBuilder.memberId(memberId);

        return requestParamsBuilder.build();
    }

    public static RequestParams authUserId(String serviceKey, String cookieId, String memberId) {
        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceType("AS")
                .cookieId(cookieId)
                .memberId(memberId);

        return requestParamsBuilder.build();
    }

    public static RequestParams authAgreedPUSH(String serviceKey, String cookieId, String userId, String agreedType, boolean isAgreed) {
        AppData.AppDataBuilder appData = AppData.builder().agreedType(agreedType);

        switch (agreedType) {
            case "AP" :
                appData.agreedAP(isAgreed);
                break;
            case "AA" :
                appData.agreedAA(isAgreed);
                break;
            case "AN" :
                appData.agreedAN(isAgreed);
                break;
        }

        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceType("AS")
                .cookieId(cookieId)
                .userId(userId)
                .appData(appData.build());

        return requestParamsBuilder.build();
    }

    public static RequestParams authPushToken(String serviceKey, String cookieId, String userId, String pushToken) {
        AppData appData = AppData.builder().token(pushToken).build();

        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceType("AS")
                .cookieId(cookieId)
                .userId(userId)
                .appData(appData);

        return requestParamsBuilder.build();
    }

    public static RequestParams authAdvertisingId(String serviceKey, String cookieId, String userId, String adid) {
        AppData appData = AppData.builder().adid(adid).build();

        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceType("AS")
                .cookieId(cookieId)
                .userId(userId)
                .appData(appData);

        return requestParamsBuilder.build();
    }

    public static RequestParams authETC(String serviceKey, String cookieId, String userId
            , String appName, String appVersion, String firmwareName, String deviceOS, int deviceSDK) {
        AppData appData = AppData.builder().appName(appName).appVersion(appVersion)
                .firmwareName(firmwareName).deviceOS(deviceOS).deviceSDK(deviceSDK).build();

        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceType("AS")
                .cookieId(cookieId)
                .userId(userId)
                .appData(appData);

        return requestParamsBuilder.build();
    }

    public static RequestParams serviceMember(String serviceKey, String cookieId, String userId
            , String memberId, String id, String grade, String gender, int age) {
        MemberData memberData = MemberData.builder().id(id).grade(grade).gender(gender).age(age).build();

        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd("MC")
                .memberId(memberId)
                .memberData(memberData);

        List<Object> touchInfo = Groobee.getInstance().getTouchEventActionData();

        if (touchInfo.size() > 0)
            Groobee.getInstance().sendTouchEventAction(touchInfo);

//        if (touchInfo.size() > 0) {
//            AppData appData = AppData.builder().touchInfo(touchInfo).build();
//            requestParamsBuilder.appData(appData);
//            Groobee.getInstance().initTouchEventActionData();
//        }

        return requestParamsBuilder.build();
    }

    public static RequestParams serviceMemberJoin(String serviceKey, String cookieId, String userId, String memberId) {
        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd("MJ")
                .memberId(memberId);

        List<Object> touchInfo = Groobee.getInstance().getTouchEventActionData();

        if (touchInfo.size() > 0)
            Groobee.getInstance().sendTouchEventAction(touchInfo);

        return requestParamsBuilder.build();
    }

    public static RequestParams serviceSearchKeyword(String serviceKey, String cookieId, String userId, String memberId, String searchKwd) {
        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd("SE")
                .searchKwd(searchKwd);

        if (memberId != null && !memberId.isEmpty())
            requestParamsBuilder.memberId(memberId);

        List<Object> touchInfo = Groobee.getInstance().getTouchEventActionData();

        if (touchInfo.size() > 0)
            Groobee.getInstance().sendTouchEventAction(touchInfo);

        return requestParamsBuilder.build();
    }

    public static RequestParams serviceShoppingCart(String serviceKey, String cookieId, String userId, String memberId, List<Goods> goodsList) {
        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd("VC")
                .goods(goodsList);

        if (memberId != null && !memberId.isEmpty())
            requestParamsBuilder.memberId(memberId);

        List<Object> touchInfo = Groobee.getInstance().getTouchEventActionData();

        if (touchInfo.size() > 0)
            Groobee.getInstance().sendTouchEventAction(touchInfo);

        return requestParamsBuilder.build();
    }

    public static RequestParams serviceGoodsOrder(String serviceKey, String cookieId, String userId, String memberId, List<Goods> goodsList) {
        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd("OR")
                .goods(goodsList);

        if (memberId != null && !memberId.isEmpty())
            requestParamsBuilder.memberId(memberId);

        List<Object> touchInfo = Groobee.getInstance().getTouchEventActionData();

        if (touchInfo.size() > 0)
            Groobee.getInstance().sendTouchEventAction(touchInfo);

        return requestParamsBuilder.build();
    }

    public static RequestParams serviceGoodsOrderComplete(String serviceKey, String cookieId, String userId, String memberId, String orderNo, List<Goods> goodsList) {
        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd("PU")
                .orderNo(orderNo)
                .goods(goodsList);

        if (memberId != null && !memberId.isEmpty())
            requestParamsBuilder.memberId(memberId);

        List<Object> touchInfo = Groobee.getInstance().getTouchEventActionData();

        if (touchInfo.size() > 0)
            Groobee.getInstance().sendTouchEventAction(touchInfo);

        return requestParamsBuilder.build();
    }

    public static RequestParams serviceViewGoods(String serviceKey, String cookieId, String userId, String memberId, List<Goods> goodsList) {
        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd("VG")
                .goods(goodsList);

        if (memberId != null && !memberId.isEmpty())
            requestParamsBuilder.memberId(memberId);

        return requestParamsBuilder.build();
    }

    public static RequestParams serviceCategory(String serviceKey, String cookieId, String userId, String memberId, String cateCd, String cateNm) {
        Category category = Category.builder().cateCd(cateCd).cateNm(cateNm).build();

        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd("CA")
                .category(category);

        if (memberId != null && !memberId.isEmpty())
            requestParamsBuilder.memberId(memberId);

        List<Object> touchInfo = Groobee.getInstance().getTouchEventActionData();

        if (touchInfo.size() > 0)
            Groobee.getInstance().sendTouchEventAction(touchInfo);

        return requestParamsBuilder.build();
    }

    public static RequestParams serviceCustomerData(String serviceKey, String cookieId, String userId, String memberId, Map<String, Object> data) {
        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd("LO")
                .customData(data);

        if (memberId != null && !memberId.isEmpty())
            requestParamsBuilder.memberId(memberId);

        List<Object> touchInfo = Groobee.getInstance().getTouchEventActionData();

        if (touchInfo.size() > 0)
            Groobee.getInstance().sendTouchEventAction(touchInfo);

        return requestParamsBuilder.build();
    }

    public static RequestParams servicePushMessageState(String serviceKey, String cookieId, String userId, String actionCd, String memberId
            , boolean isUsed, List<CampaignKeyData> campaignKeyList) {

        AppData.AppDataBuilder appData = AppData.builder().campaignKeyList(campaignKeyList);

        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd(actionCd);

        List<Object> touchInfo = Groobee.getInstance().getTouchEventActionData();

        if (touchInfo.size() > 0)
            Groobee.getInstance().sendTouchEventAction(touchInfo);

        if (actionCd == "PO")
            appData.pushOpened(isUsed);

        requestParamsBuilder.appData(appData.build());

        if (memberId != null && !memberId.isEmpty())
            requestParamsBuilder.memberId(memberId);

        return requestParamsBuilder.build();
    }

    public static RequestParams serviceScreenData(String serviceKey, String cookieId, String userId, String memberId
            , Activity activity, String screenName) {
        AppData.AppDataBuilder appData = AppData.builder().screenAct(activity.getLocalClassName())
                .screenData(activity.getComponentName().getClassName()).screenName(screenName);

        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd("SC");

        List<Object> touchInfo = Groobee.getInstance().getTouchEventActionData();

        if (touchInfo.size() > 0)
            Groobee.getInstance().sendTouchEventAction(touchInfo);

        requestParamsBuilder.appData(appData.build());

        if (memberId != null && !memberId.isEmpty())
            requestParamsBuilder.memberId(memberId);

        return requestParamsBuilder.build();
    }

    public static RequestParams serviceCustomerLocation(String serviceKey, String cookieId, String userId, String memberId
            , double latitude, double longitude) {
        AppData.AppDataBuilder appData = AppData.builder().latitude(latitude).longitude(longitude);

        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd("LC");

        List<Object> touchInfo = Groobee.getInstance().getTouchEventActionData();

        if (touchInfo.size() > 0)
            Groobee.getInstance().sendTouchEventAction(touchInfo);

        requestParamsBuilder.appData(appData.build());

        if (memberId != null && !memberId.isEmpty())
            requestParamsBuilder.memberId(memberId);

        return requestParamsBuilder.build();
    }

    public static RequestParams serviceTouchEventActionData(String serviceKey, String cookieId, String userId, String memberId, List<Object> touchInfo) {
        AppData appData = AppData.builder().touchInfo(touchInfo).build();

        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd("TO")
                .appData(appData);

        if (memberId != null && !memberId.isEmpty())
            requestParamsBuilder.memberId(memberId);

        return requestParamsBuilder.build();
    }

    public static RequestParams serviceSessionState(String serviceKey, String cookieId, String userId, String memberId, String actionCd, boolean isTerminate) {
        AppData.AppDataBuilder appData = AppData.builder().terMinated(isTerminate);

        RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder()
                .serviceKey(serviceKey)
                .deviceCd("AS")
                .cookieId(cookieId)
                .userId(userId)
                .actionCd(actionCd);

        List<Object> touchInfo = Groobee.getInstance().getTouchEventActionData();

        if (touchInfo.size() > 0)
            Groobee.getInstance().sendTouchEventAction(touchInfo);

        requestParamsBuilder.appData(appData.build());

        if (memberId != null && !memberId.isEmpty())
            requestParamsBuilder.memberId(memberId);

        return requestParamsBuilder.build();
    }

}
