package com.groobee.message.common;

import android.content.Context;
import android.content.SharedPreferences;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.BasicNetwork;
import com.android.volley.toolbox.DiskBasedCache;
import com.android.volley.toolbox.HurlStack;
import com.android.volley.toolbox.JsonObjectRequest;
import com.groobee.message.Groobee;
import com.groobee.message.R;
import com.groobee.message.providers.RuntimeConfigProvider;
import com.groobee.message.utils.LoggerUtils;

import org.json.JSONObject;

public class GroobeeServiceManager {
    private static final String TAG = LoggerUtils.getClassLogTag(Groobee.class);

    private final Context context;

    private final DiskBasedCache cache;
    private final BasicNetwork network;
    private final RequestQueue requestQueue;

    private SharedPreferences sharedPreferences;
    private RuntimeConfigProvider runtimeConfigProvider;

    private final String CONTENT_TYPE;

    public GroobeeServiceManager(Context context) {
        this.context = context;
        this.CONTENT_TYPE = context.getString(R.string.CONTENT_TYPE);

        cache = new DiskBasedCache(context.getCacheDir(), 1024 * 1024);
        network = new BasicNetwork(new HurlStack());
        requestQueue = new RequestQueue(cache, network);
        requestQueue.start();

        sharedPreferences = context.getSharedPreferences(RuntimeConfigProvider.PREFERENCES_NAME, Context.MODE_PRIVATE);
        runtimeConfigProvider = new RuntimeConfigProvider(context);
    }

    public void sendRequest(String url, JSONObject param) {
        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, url, param, response -> {
            try {
                if(url.matches(".*" + ServicesConstants.AUTH_API_USER_ID)) {
                    String userId = response.getString("userId");
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_USER_ID, userId);
                    editor.apply();
                }

//                LoggerUtils.d(TAG, "response : " + response +", url : " + url);
//                LoggerUtils.d(TAG, "param : " + param);
            } catch (Exception e) {}
        }, error -> {
//            LoggerUtils.d(TAG, "error : " + error);
        }) {
            @Override
            public String getBodyContentType() {
                return CONTENT_TYPE;
            }
        };

        requestQueue.add(request);
    }
}
