package com.groobee.message.utils;

import android.Manifest;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;

import androidx.core.app.ActivityCompat;

import java.util.List;

public class CommonUtils {

    public static String getAppName(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();

        int res = applicationInfo.labelRes;
        String appName = "";

        if(!TextUtils.isEmpty(applicationInfo.nonLocalizedLabel))
            appName = applicationInfo.nonLocalizedLabel.toString();

        if(res > 0)
            appName = context.getString(res);

        return appName;
    }

    @SuppressWarnings("MissingPermission")
    public static Location getLatLng(Context context) {
        LocationManager locationManager =  (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);
        final Location[] location = {null};

        if(ActivityCompat.checkSelfPermission(context, Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED
        && ActivityCompat.checkSelfPermission(context, Manifest.permission.ACCESS_COARSE_LOCATION) == PackageManager.PERMISSION_GRANTED) {
            Thread thread = new Thread() {
                @Override
                public void run() {
                    try {
                        location[0] = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);

                        if (location[0] == null)
                            location[0] = locationManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);

                        if (location[0] == null)
                            location[0] = locationManager.getLastKnownLocation(LocationManager.PASSIVE_PROVIDER);

                        if (location[0] == null) {
                            LocationListener locationListener = new LocationListener() {
                                @Override
                                public void onLocationChanged(Location loc) {
                                    location[0] = loc;
                                }
                            };

                            if (locationManager.isProviderEnabled(locationManager.PASSIVE_PROVIDER) == true) {
                                locationManager.requestLocationUpdates(LocationManager.PASSIVE_PROVIDER, 1000, 0, locationListener);
                            }

                            if (locationManager.isProviderEnabled(locationManager.NETWORK_PROVIDER) == true) {
                                locationManager.requestLocationUpdates(LocationManager.NETWORK_PROVIDER, 1000, 0, locationListener);
                            }

                            if (locationManager.isProviderEnabled(locationManager.GPS_PROVIDER) == true) {
                                locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 1000, 0, locationListener);
                            }
                        }

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };

            thread.start();
        }

        return location[0];
    }

    public static String getDeviceOS() {
        return Build.VERSION.RELEASE;
    }

    public static int getDeviceSDK() {
        return Build.VERSION.SDK_INT;
    }

    public static String getFirmwareName() {
        return Build.VERSION.INCREMENTAL;
    }

    public static String getAppVersion(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0 );
            return packageInfo.versionName;
        } catch (PackageManager.NameNotFoundException e) {
            return "";
        }
    }

    public void getInstalledPackages(Context context) {
        List<PackageInfo> packageInfo = context.getPackageManager().getInstalledPackages(0);

        for (PackageInfo info : packageInfo) {
//            Log.d("nh", "packageName: " + info.packageName
//                    + ", versionName: " + info.versionName
//                    + ", lastUpdateTime: " + info.lastUpdateTime
//                    + ", firstInstallTime : " + info.firstInstallTime
//                    + ", targetSdk: " + info.applicationInfo.targetSdkVersion
//                    + ", label: " + info.applicationInfo.loadLabel(context.getPackageManager()));
        }
    }
}
