package com.groobee.message;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;

import androidx.core.view.GestureDetectorCompat;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.groobee.message.common.GoogleAdvertising;
import com.groobee.message.common.GroobeeImageLoader;
import com.groobee.message.common.GroobeeServiceManager;
import com.groobee.message.common.HttpLoader;
import com.groobee.message.common.ModelBuilder;
import com.groobee.message.common.ModelTouchBuilder;
import com.groobee.message.common.ServicesConstants;
import com.groobee.message.common.thread.HandlerUncaughtException;
import com.groobee.message.common.thread.WorkingThreadFactory;
import com.groobee.message.common.thread.WorkingThreadLarge;
import com.groobee.message.common.thread.WorkingThreadSmall;
import com.groobee.message.inappmessage.ButtonType;
import com.groobee.message.inappmessage.MessageType;
import com.groobee.message.inappmessage.NoOpDisplayCallbacks;
import com.groobee.message.inappmessage.displays.GroobeeInAppMessageDisplay;
import com.groobee.message.inappmessage.interfaces.GroobeeInAppMessagingDisplayCallbacks;
import com.groobee.message.inappmessage.model.InAppMessage;
import com.groobee.message.inappmessage.model.MessageButton;
import com.groobee.message.inappmessage.model.MessageText;
import com.groobee.message.inappmessage.utils.RenewableTimer;
import com.groobee.message.models.CampaignKeyData;
import com.groobee.message.models.Goods;
import com.groobee.message.models.RequestParams;
import com.groobee.message.models.TouchDefultData;
import com.groobee.message.models.TouchFlingData;
import com.groobee.message.models.TouchScrollData;
import com.groobee.message.providers.GroobeeConfigProvider;
import com.groobee.message.providers.RuntimeConfigProvider;
import com.groobee.message.push.interfaces.InterfaceGroobeeNotificationFactory;
import com.groobee.message.utils.Base64Utils;
import com.groobee.message.utils.CommonUtils;
import com.groobee.message.utils.DateUtils;
import com.groobee.message.utils.LoggerUtils;
import com.groobee.message.utils.PackageUtils;
import com.groobee.message.utils.StringUtils;
import com.groobee.message.utils.WebViewUtils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.inject.Singleton;

@Singleton
public class Groobee {
    private static final String TAG = LoggerUtils.getClassLogTag(Groobee.class);

    private static volatile InterfaceGroobeeNotificationFactory interfaceGroobeeNotificationFactory;

    private static Context context;

    private GroobeeImageLoader groobeeImageLoader;

    private HandlerUncaughtException handlerUncaughtException;

    private WorkingThreadSmall workingThreadSmall;

    private WorkingThreadLarge workingThreadLarge;

    private GroobeeConfigProvider groobeeConfigProvider;

    private RuntimeConfigProvider runtimeConfigProvider;

    private GroobeeServiceManager groobeeServiceManager;

    private SharedPreferences sharedPreferences;

    private GestureDetectorCompat gestureDetectorCompat;

    private boolean isDebugMode = false;

    private static boolean isAuth = false;

    private String urlAuth;
    private String urlService;

    private final int SESSION_CLOSING_DURATION = (30 * 60) * 1000;
    private final int TIMER_INTERVAL_SECOND = 1000;

    private RenewableTimer sessionPushOpenTimer = null;

    private static class LazyHolder {
        private static final Groobee INSTANCE = new Groobee();
    }

    public static Groobee getInstance() {
        return LazyHolder.INSTANCE;
    }

    public Groobee() {
        handlerUncaughtException = new HandlerUncaughtException();

        WorkingThreadFactory workingThreadFactory = new WorkingThreadFactory("Groobee-Working-Pool-Thread");
        workingThreadFactory.setUncaughtExceptionHandler(handlerUncaughtException);

        workingThreadSmall = new WorkingThreadSmall("identifier", workingThreadFactory);
        workingThreadLarge = new WorkingThreadLarge("identifier-large", workingThreadFactory);

        if (isDebugMode) {
            urlAuth = ServicesConstants.AUTH_DEV_URL;
            urlService = ServicesConstants.SERVICES_DEV_URL;
        } else {
            urlAuth = ServicesConstants.AUTH_OPR_URL;
            urlService = ServicesConstants.SERVICES_OPR_URL;
        }
    }

    public static boolean configure(Context context, GroobeeConfig config) {
        LoggerUtils.d(TAG, "configure() called with configuration: " + config.getApiKey());

        getInstance().runtimeConfigProvider = new RuntimeConfigProvider(context);
        getInstance().context = context.getApplicationContext();
        getInstance().groobeeImageLoader = new GroobeeImageLoader(context);
        getInstance().groobeeConfigProvider = new GroobeeConfigProvider(context);
        getInstance().sharedPreferences = context.getSharedPreferences(RuntimeConfigProvider.PREFERENCES_NAME, Context.MODE_PRIVATE);
        getInstance().groobeeServiceManager = new GroobeeServiceManager(context);
        getInstance().gestureDetectorCompat = new GestureDetectorCompat(context, getInstance().new mGestureListener());

        String userId = getInstance().sharedPreferences.getString(getInstance().runtimeConfigProvider.PREFERENCES_USER_ID, null);
        String memberId = getInstance().sharedPreferences.getString(getInstance().runtimeConfigProvider.PREFERENCES_MEMBER_ID, null);
        String packageName = PackageUtils.getResourcePackageName(context);
        RequestParams requestParams = ModelBuilder.authServiceKey(config.getApiKey(), getInstance().getCookieId(), userId, packageName, memberId);

        getInstance().setAuthServiceKey(requestParams);
        getInstance().getAdvertisingId();
        getInstance().setETC();
        getInstance().setCustomerLocation();

        if(config != null) {
            getInstance().runtimeConfigProvider.setRuntimeConfig(config);
            return true;
        }

        getInstance().runtimeConfigProvider.clean();

        return false;
    }

    public GroobeeInAppMessageDisplay getActivityLifecycleCallbacks() {
        return GroobeeInAppMessageDisplay.getInstance();
    }

    public GroobeeImageLoader getImageLoader() {
        if (groobeeImageLoader == null) {
            LoggerUtils.d(TAG, "The Image Loader was null. Creating a new Image Loader and returning it.");
            groobeeImageLoader = new GroobeeImageLoader(context);
        }

        return groobeeImageLoader;
    }

    private String getCookieId() {
        String uuid = sharedPreferences.getString(getInstance().runtimeConfigProvider.PREFERENCES_UUID, null);

        if (uuid == null || uuid.isEmpty()) {
            uuid = UUID.randomUUID().toString();
            SharedPreferences.Editor editor = getInstance().sharedPreferences.edit();
            getInstance().runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_UUID, uuid);
            editor.apply();
        }

        return uuid;
    }

    private void setCustomerLocation() {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    Location location = CommonUtils.getLatLng(context);

                    if(location != null) {
                        if (getInstance().isAuth) {
                            String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                            String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                            if (StringUtils.isNullOrEmpty(userId))
                                userId = getCookieId();

                            RequestParams requestParams = ModelBuilder.serviceCustomerLocation(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId
                                    , memberId, location.getLatitude(), location.getLongitude());
                            JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                            groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                        } else
                            LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");
                    }
                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging setCustomerLocation", e);
                }
            }
        });
    }

    private void setAuthServiceKey(RequestParams requestParams) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                    isAuth = HttpLoader.isAuthConnection(getInstance().urlAuth + ServicesConstants.AUTH_API_APP, request);
                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging setAuthServiceKey", e);
                }
            }
        });
    }

    private JsonArray reStorageCampaignKeyList(String campaignKey) {
        String campaignKeyList = runtimeConfigProvider.getData(RuntimeConfigProvider.PREFERENCES_PUSH_CAMPAIGN_LIST, "");
        JsonArray jsonCampaignKeyList = new JsonArray();

        if(!campaignKeyList.isEmpty())
            jsonCampaignKeyList = (JsonArray) JsonParser.parseString(campaignKeyList);

        for(int i = 0; i < jsonCampaignKeyList.size(); i++) {
            JsonObject campaignData = (JsonObject) jsonCampaignKeyList.get(i);
            if (campaignData.get("campaignKey").getAsString().equals(campaignKey)) {
                jsonCampaignKeyList.remove(i);
                i = -1;
            }
        }

        return jsonCampaignKeyList;
    }

    private boolean hasCampaignKeyList(String campaignKey) {
        String campaignKeyList = runtimeConfigProvider.getData(RuntimeConfigProvider.PREFERENCES_PUSH_CAMPAIGN_LIST, "");
        JsonArray jsonCampaignKeyList = new JsonArray();
        boolean result = false;

        if(!campaignKeyList.isEmpty())
            jsonCampaignKeyList = (JsonArray) JsonParser.parseString(campaignKeyList);

        for(int i = 0; i < jsonCampaignKeyList.size(); i++) {
            JsonObject campaignData = (JsonObject) jsonCampaignKeyList.get(i);
            if (campaignData.get("campaignKey").getAsString().equals(campaignKey)) {
                result = true;
                break;
            }
        }

        return result;
    }

    public void setServiceLogin(String memberId) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        if(!StringUtils.isNullOrBlank(memberId)) {
                            SharedPreferences.Editor editor = getInstance().sharedPreferences.edit();
                            getInstance().runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_MEMBER_ID, memberId);
                            editor.apply();

                            if (StringUtils.isNullOrEmpty(memberId)) {
                                LoggerUtils.w(TAG, "The value of memberId is empty.");
                                return;
                            }

                            RequestParams requestParams = ModelBuilder.authUserId(groobeeConfigProvider.getGroobeeApiKey(), getInstance().getCookieId(), memberId);
                            JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                            groobeeServiceManager.sendRequest(getInstance().urlAuth + ServicesConstants.AUTH_API_USER_ID, request);
                        } else
                            LoggerUtils.w(TAG, "Member variable is empty. You need to check the value.");
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setServiceLogin() logging", e);
                }
            }
        });
    }

    public void setAgreedPush(boolean agreed) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        RequestParams requestParams = ModelBuilder.authAgreedPUSH(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, "AP", agreed);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlAuth + ServicesConstants.AUTH_API_AGREED, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setAgreedPush() logging", e);
                }
            }
        });
    }

    public void setAgreedPushAdvertising(boolean agreed) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        RequestParams requestParams = ModelBuilder.authAgreedPUSH(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, "AA", agreed);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlAuth + ServicesConstants.AUTH_API_AGREED, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setAgreedPushAdvertising() logging", e);
                }
            }
        });
    }

    public void setAgreedPushNight(boolean agreed) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        RequestParams requestParams = ModelBuilder.authAgreedPUSH(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, "AN", agreed);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlAuth + ServicesConstants.AUTH_API_AGREED, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setAgreedPushNight() logging", e);
                }
            }
        });
    }

    public void setPushToken(String pushToken) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        if (StringUtils.isNullOrEmpty(pushToken)) {
                            LoggerUtils.w(TAG, "The value of pushToken is empty.");
                            return;
                        }

                        RequestParams requestParams = ModelBuilder.authPushToken(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, pushToken);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlAuth + ServicesConstants.AUTH_API_PUSH_TOKEN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setPushToken() logging", e);
                }
            }
        });
    }

    private void getAdvertisingId() {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        new GoogleAdvertising(context).getAdId();
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method getAdvertisingId() logging", e);
                }
            }
        });
    }

    public void setAdvertisingId(String adid) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        RequestParams requestParams = ModelBuilder.authAdvertisingId(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, adid);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlAuth + ServicesConstants.AUTH_API_ADID, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setAdvertisingId() logging", e);
                }
            }
        });
    }

    private void setETC() {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        RequestParams requestParams = ModelBuilder.authETC(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId
                                , CommonUtils.getAppName(context), CommonUtils.getAppVersion(context), CommonUtils.getFirmwareName()
                                , CommonUtils.getDeviceOS(), CommonUtils.getDeviceSDK());
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlAuth + ServicesConstants.AUTH_API_ETC, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setETC() logging", e);
                }
            }
        });
    }

    public void setMember(String id, String grade, String gender, int age) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(memberId)) {
                            LoggerUtils.w(TAG, "Method available after login. Prior to calling setServiceLogin Method.");
                            return;
                        }

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        if (StringUtils.isNullOrEmpty(id) || StringUtils.isNullOrEmpty(grade) || StringUtils.isNullOrEmpty(gender)) {
                            LoggerUtils.w(TAG, "The value of setMember is empty.");
                            return;
                        }

                        RequestParams requestParams = ModelBuilder.serviceMember(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId
                                , memberId, id, grade, gender.toUpperCase(), age);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setMember() logging", e);
                }
            }
        });
    }

    public void setMemberJoin(String memberId) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        if (StringUtils.isNullOrEmpty(memberId)) {
                            LoggerUtils.w(TAG, "The value of memberId is empty.");
                            return;
                        }

                        RequestParams requestParams = ModelBuilder.serviceMemberJoin(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, memberId);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setMemberJoin() logging", e);
                }
            }
        });
    }

    public void setSearchKeyword(String keyword) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        if (StringUtils.isNullOrEmpty(keyword)) {
                            LoggerUtils.w(TAG, "The value of keyword is empty.");
                            return;
                        }

                        RequestParams requestParams = ModelBuilder.serviceSearchKeyword(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, memberId, keyword);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setSearchKeyword() logging", e);
                }
            }
        });
    }

    public void setShoppingCart(List<Goods> goodsList) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        if (goodsList == null || goodsList.size() < 1) {
                            LoggerUtils.w(TAG, "goodsList size is 0. Check the data of the goods.");
                            return;
                        }

                        RequestParams requestParams = ModelBuilder.serviceShoppingCart(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, memberId, goodsList);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setShoppingCart() logging", e);
                }
            }
        });
    }

    public void setGoodsOrder(List<Goods> goodsList) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        if (goodsList == null || goodsList.size() < 1) {
                            LoggerUtils.w(TAG, "goodsList size is 0. Check the data of the goods.");
                            return;
                        }

                        RequestParams requestParams = ModelBuilder.serviceGoodsOrder(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, memberId, goodsList);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setGoodsOrder() logging", e);
                }
            }
        });
    }

    public void setGoodsOrderComplete(String orderNm, List<Goods> goodsList) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        if (StringUtils.isNullOrEmpty(orderNm)) {
                            LoggerUtils.w(TAG, "The value of orderNm is empty.");
                            return;
                        }

                        if (goodsList == null || goodsList.size() < 1) {
                            LoggerUtils.w(TAG, "goodsList size is 0. Check the data of the goods.");
                            return;
                        }

                        RequestParams requestParams = ModelBuilder.serviceGoodsOrderComplete(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, memberId
                                , orderNm, goodsList);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setGoodsOrderComplete() logging", e);
                }
            }
        });
    }

    public void setViewGoods(Goods goods) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        if (goods == null) {
                            LoggerUtils.w(TAG, "The value of goods is null.");
                            return;
                        }

                        if (StringUtils.isNullOrEmpty(goods.getGoodsNm())) {
                            LoggerUtils.w(TAG, "The value of goodsNm is empty.");
                            return;
                        }

                        if (StringUtils.isNullOrEmpty(goods.getGoodsCd())) {
                            LoggerUtils.w(TAG, "The value of goodsCd is empty.");
                            return;
                        }

                        if (StringUtils.isNullOrEmpty(goods.getGoodsImg())) {
                            LoggerUtils.w(TAG, "The value of goodsImg is empty.");
                            return;
                        }

                        SharedPreferences.Editor editor = sharedPreferences.edit();
                        runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_IS_VIEW_GOODS, true);
                        editor.apply();

                        List<Goods> goodsList = new ArrayList<>();
                        goodsList.add(goods);

                        RequestParams requestParams = ModelBuilder.serviceViewGoods(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, memberId, goodsList);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setViewGoods() logging", e);
                }
            }
        });
    }

    public void setCategory(String cateCd, String cateNm) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        if (StringUtils.isNullOrEmpty(cateCd) || StringUtils.isNullOrEmpty(cateNm)) {
                            LoggerUtils.w(TAG, "The value of setCategory is empty.");
                            return;
                        }

                        RequestParams requestParams = ModelBuilder.serviceCategory(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, memberId, cateCd, cateNm);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setCategory() logging", e);
                }
            }
        });
    }

    public void setCustomerData(Map<String, Object> customData) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        if (customData == null || customData.size() < 1) {
                            LoggerUtils.w(TAG, "The value of customData is empty.");
                            return;
                        }

                        RequestParams requestParams = ModelBuilder.serviceCustomerData(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, memberId, customData);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setCustomerData() logging", e);
                }
            }
        });
    }

    public void setScreenData(Activity activity, String screenName) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        if (StringUtils.isNullOrEmpty(screenName)) {
                            LoggerUtils.w(TAG, "The value of screenName is empty.");
                            return;
                        }

                        RequestParams requestParams = ModelBuilder.serviceScreenData(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, memberId
                                , activity, screenName);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setScreenData() logging", e);
                }
            }
        });
    }

    public void setDispatchTouchEvent(MotionEvent motionEvent) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    gestureDetectorCompat.onTouchEvent(motionEvent);
                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method setDispatchTouchEvent() logging", e);
                }
            }
        });
    }

    public void sendTouchEventAction(List<Object> touchInfo) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

//                        JsonArray jsonArray = JsonParser.parseString(touchData).getAsJsonArray();

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

//                        if (jsonArray.size() < 1) {
//                            LoggerUtils.w(TAG, "The value of touchData Size is 0.");
//                            return;
//                        }

//                        List<Object> touchInfo = new Gson().fromJson(jsonArray, new TypeToken<List<Object>>(){}.getType());
                        RequestParams requestParams = ModelBuilder.serviceTouchEventActionData(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId, memberId, touchInfo);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                        initTouchEventActionData();
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method sendTouchEventAction() logging", e);
                }
            }
        });
    }

    public List<Object> getTouchEventActionData() {
        String touchData = runtimeConfigProvider.getData(RuntimeConfigProvider.PREFERENCES_SCREEN_TOUCH_DATA, "[]");
        JsonArray jsonArray = JsonParser.parseString(touchData).getAsJsonArray();
        List<Object> touchInfo = new Gson().fromJson(jsonArray, new TypeToken<List<Object>>(){}.getType());
        return touchInfo;
    }

    private void initTouchEventActionData() {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_IS_VIEW_GOODS, false);
        runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_SCREEN_TOUCH_DATA, "[]");
        editor.apply();
    }

    public static void setCustomGroobeeNotificationFactory(InterfaceGroobeeNotificationFactory customGroobeeNotificationFactory) {
        LoggerUtils.d(TAG, "Custom Braze notification factory set");
        interfaceGroobeeNotificationFactory = customGroobeeNotificationFactory;
    }

    public static InterfaceGroobeeNotificationFactory getCustomGroobeeNotificationFactory() {
        return interfaceGroobeeNotificationFactory;
    }

    public void logPushNotificationActionClicked(final String campaignId, final String actionId, final String actionType) {
        LoggerUtils.d(TAG, "call method logPushNotificationActionClicked");

        /**
        *Push 클릭한 내용 서버 전송
        * */
    }

    public void logPushNotificationOpened(final Intent intent) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String keyCid = context.getString(R.string.KEY_VARIABLE_CAMPAIGN_ID);
                        String keyType = context.getString(R.string.KEY_VARIABLE_CAMPAIGN_TYPE);
                        String keyPushMsgCnt = context.getString(R.string.KEY_VARIABLE_CAMPAIGN_PUSH_MESSAGE_COUNT);

                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        if (intent.hasExtra(keyCid) && intent.hasExtra(keyType) && intent.hasExtra(keyPushMsgCnt)) {
                            String cid = intent.getStringExtra(keyCid);
                            String type = intent.getStringExtra(keyType);
                            String pushMsgCnt = intent.getStringExtra(keyPushMsgCnt);

                            if (!StringUtils.isNullOrBlank(cid)) {
                                JsonArray jsonCampaignKeyList = reStorageCampaignKeyList(cid);
                                SharedPreferences.Editor editor = sharedPreferences.edit();

//                                LoggerUtils.d(TAG, "Logging push click to notification. Campaign Id: " + jsonCampaignKeyList);

                                if (jsonCampaignKeyList.size() > 0)
                                    runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_PUSH_CAMPAIGN_LIST, jsonCampaignKeyList.toString());
                                else
                                    runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_PUSH_CAMPAIGN_LIST, "");
                                editor.apply();

                                CampaignKeyData campaignKeyData = CampaignKeyData.builder().campaignKey(cid).pushMsgType(type).pushMsgCnt(pushMsgCnt).build();
                                List<CampaignKeyData> campaignKeyList = new ArrayList<>();
                                campaignKeyList.add(campaignKeyData);

                                RequestParams requestParams = ModelBuilder.servicePushMessageState(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId
                                        , "PO", memberId, true, campaignKeyList);
                                JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                                groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                            } else {
                                LoggerUtils.i(TAG, "Not Found campaign Id with this notification");
                            }
                        }
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging push notification", e);
                }
            }
        });
    }

    public void logPushNotificationDeleted(final Intent intent) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String keyCid = context.getString(R.string.KEY_VARIABLE_CAMPAIGN_ID);
                        String keyType = context.getString(R.string.KEY_VARIABLE_CAMPAIGN_TYPE);
                        String keyPushMsgCnt = context.getString(R.string.KEY_VARIABLE_CAMPAIGN_PUSH_MESSAGE_COUNT);

                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        if (intent.hasExtra(keyCid) && intent.hasExtra(keyType) && intent.hasExtra(keyPushMsgCnt)) {
                            String cid = intent.getStringExtra(keyCid);
                            String type = intent.getStringExtra(keyType);
                            String pushMsgCnt = intent.getStringExtra(keyPushMsgCnt);

                            if (!StringUtils.isNullOrBlank(cid)) {
                                CampaignKeyData campaignKeyData = CampaignKeyData.builder().campaignKey(cid).pushMsgType(type).pushMsgCnt(pushMsgCnt).build();
                                List<CampaignKeyData> campaignKeyList = new ArrayList<>();
                                campaignKeyList.add(campaignKeyData);

                                RequestParams requestParams = ModelBuilder.servicePushMessageState(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId
                                        , "PD", memberId, true, campaignKeyList);
                                JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                                groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                            } else {
                                LoggerUtils.i(TAG, "Not Found campaign Id with this notification");
                            }
                        }
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging push notification", e);
                }
            }
        });
    }

    public void logPushIndirectOpened(JsonArray campaignKeyList) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        List<CampaignKeyData> campaignKeyDataList = new Gson().fromJson(campaignKeyList, new TypeToken<List<CampaignKeyData>>(){}.getType());

                        SharedPreferences.Editor editor = sharedPreferences.edit();
                        runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_PUSH_CAMPAIGN_LIST, "");
                        editor.apply();

                        RequestParams requestParams = ModelBuilder.servicePushMessageState(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId
                                , "PO", memberId, false, campaignKeyDataList);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");
                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging push notification", e);
                }
            }
        });
    }

    public void initPushOpenSession() {
        if(sessionPushOpenTimer != null) {
            sessionPushOpenTimer.cancel();
            sessionPushOpenTimer = null;
        }
    }

    public void logPushDeliveryEvent(final String campaignId, final String campaignType, final String campaignCnt) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        initPushOpenSession();

                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        String campaignKeyList = runtimeConfigProvider.getData(RuntimeConfigProvider.PREFERENCES_PUSH_CAMPAIGN_LIST, "");

                        JsonArray jsonCampaignKeyList = new JsonArray();

                        if(!campaignKeyList.isEmpty())
                            jsonCampaignKeyList = (JsonArray) JsonParser.parseString(campaignKeyList);

                        if (!hasCampaignKeyList(campaignId)) {
                            CampaignKeyData campaignKeyData = CampaignKeyData.builder().campaignKey(campaignId).pushMsgType(campaignType).pushMsgCnt(campaignCnt).build();
                            jsonCampaignKeyList.add(new Gson().toJsonTree(campaignKeyData, CampaignKeyData.class));

                            SharedPreferences.Editor editor = sharedPreferences.edit();
                            runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_PUSH_CAMPAIGN_LIST, jsonCampaignKeyList.toString());
                            editor.apply();

                            List<CampaignKeyData> campaignKeyDataList = new ArrayList<>();
                            campaignKeyDataList.add(campaignKeyData);
                            RequestParams requestParams = ModelBuilder.servicePushMessageState(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId
                                    , "PR", memberId, false, campaignKeyDataList);
                            JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                            groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                        }

                        if (PackageUtils.getCurrentPackageName(context).matches(PackageUtils.getResourcePackageName(context) + ".*"))
                            logPushIndirectOpened(jsonCampaignKeyList);

                        if (sessionPushOpenTimer == null) {
                            sessionPushOpenTimer = new RenewableTimer();
                            Handler mHandler = new Handler(Looper.getMainLooper());
                            mHandler.postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    sessionPushOpenTimer.start(new RenewableTimer.Callback() {
                                        @Override
                                        public void onFinish() {
                                            sessionPushOpenTimer = null;
                                            SharedPreferences.Editor editor = sharedPreferences.edit();
                                            runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_PUSH_CAMPAIGN_LIST, "");
                                            editor.apply();
                                        }
                                    }, SESSION_CLOSING_DURATION, TIMER_INTERVAL_SECOND);
                                }
                            }, 0);
                        }
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");
                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error method logPushDeliveryEvent() logging push notification", e);
                }
            }
        });
    }

    public void showDialog(final Activity activity) {
//        LoggerUtils.d(TAG, "call showDialog : " + getInstance().groobeeServiceManager.isAuth());

        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    MessageText title = new MessageText.Builder().setText("Title TEST!!").build();
                    MessageText body = new MessageText.Builder().setText("Body TEST!!").build();

                    MessageButton messageButton1 = new MessageButton.Builder()
                            .setText("Button1")
                            .setEventUrl("https://naver.com")
                            .build();
                    Map<ButtonType, MessageButton> messageButton = new HashMap<>();
                    messageButton.put(ButtonType.POSITIVE, messageButton1);

                    Map<String, String> data = new HashMap<>();

                    InAppMessage inAppMessage = new InAppMessage(title, body, null, messageButton, data, MessageType.DIALOG);

//                    getInstance().showMessagePopup(activity, inAppMessage, new NoOpDisplayCallbacks());
                    GroobeeInAppMessageDisplay.getInstance().showMessagePopup(activity, inAppMessage, new NoOpDisplayCallbacks());
//                    GroobeeInAppMessageDisplay.getInstance().showMessagePopup(activity, inAppMessage, callbacks);

//                    LoggerUtils.d(TAG, "call showDialog : " + getInstance().groobeeServiceManager.isAuth());

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging push notification", e);
                }
            }
        });
    }

    public void showDialog(final Activity activity, final View.OnClickListener onClickListener, GroobeeInAppMessagingDisplayCallbacks callbacks) {
//        LoggerUtils.d(TAG, "call showDialog " + context.getString(R.string.txt_test));

        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    MessageText title = new MessageText.Builder().setText("Title TEST!!").build();
                    MessageText body = new MessageText.Builder().setText("Body TEST!! " + groobeeConfigProvider.getGroobeeApiKey()).build();
//                    MessageText body = new MessageText.Builder()
//                            .setText("<div id=\"imgMapGrid\"><img name=\"selectedTemplateImage\" id=\"pcSelectedTemplateImageA\"" +
//                                    " src=\"https://s3.ap-northeast-2.amazonaws.com/static.groobee.io/banner/2020/02/05/323cfbef17bd471eb5a4e4013a1b6f86/af7b30739d5c404b818ed965175860db.png\"" +
//                                    " style=\"width: 250px; height: 350px;\"></div>").build();

                    MessageButton messageButton1 = new MessageButton.Builder()
                            .setText("Button1")
                            .setEventUrl("https://naver.com")
                            .build();

                    MessageButton messageButton2 = new MessageButton.Builder()
                            .setText("Button2")
//                            .setActivityName(activity.getClass().getName())

//                            .setActivityName("com.example.test.groobee2.ActivityScreen3")
                            .setOnClickListener(onClickListener)
                            .build();

                    Map<ButtonType, MessageButton> messageButton = new HashMap<>();

//                    if(messageButton.containsKey(ButtonType.POSITIVE))
                    messageButton.put(ButtonType.NEGATIVE, messageButton2);
//                    else
                    messageButton.put(ButtonType.POSITIVE, messageButton1);

                    Map<String, String> data = new HashMap<>();

//                    InAppMessage inAppMessage = new InAppMessage(title, body, "https://static.hubzum.zumst.com/hubzum/2018/03/21/10/b4af8da309e846cc87927e8e6f939b23.jpg"
                    InAppMessage inAppMessage = new InAppMessage(title, body, "https://encrypted-tbn0.gstatic.com/images?q=tbn%3AANd9GcS_boWRLNjwhmPe_XoV2Ed72Ad5z1cRhFt100de4oV9sxbj4gJW&usqp=CAU"
                            , messageButton, data, MessageType.DIALOG);
//                            , messageButton, data, MessageType.HTML_MODAL);

//                    groobeeInAppMessageDisplay.showMessagePopup(activity, inAppMessage, new NoOpDisplayCallbacks());
//                    groobeeInAppMessageDisplay.showMessagePopup(activity, inAppMessage, null);
                    GroobeeInAppMessageDisplay.getInstance().showMessagePopup(activity, inAppMessage, callbacks);

                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging push notification", e);
                }
            }
        });
    }

    public void setWebViewLogger(final String url) {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String grb_ck = WebViewUtils.getCookieById(url, context.getString(R.string.KEY_VARIABLE_GROOBEE_CK));
                    String grb_ui = WebViewUtils.getCookieById(url, context.getString(R.string.KEY_VARIABLE_GROOBEE_UI));

                    if (!StringUtils.isNullOrBlank(grb_ck) || !StringUtils.isNullOrBlank(grb_ui)) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String cookieId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_UUID, null);
                        boolean isAdd = false;

                        SharedPreferences.Editor editor = getInstance().sharedPreferences.edit();
                        if (cookieId == null || !cookieId.equals(grb_ck)) {
                            isAdd = true;
                            runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_UUID, grb_ck);
                        }

                        if (userId == null || !userId.equals(grb_ui)) {
                            isAdd = true;
                            runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_USER_ID, grb_ui);
                        }

                        if (isAdd)
                            editor.apply();
                    }
                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging webview cookie", e);
                }
            }
        });
    }

    public class mGestureListener implements GestureDetector.OnGestureListener {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        String touchScreenData;
        boolean isViewGoods;

        @Override
        public boolean onDown(MotionEvent motionEvent) {
            /**화면 터치되면 발생**/
            isViewGoods = sharedPreferences.getBoolean(RuntimeConfigProvider.PREFERENCES_IS_VIEW_GOODS, false);

            if (isViewGoods) {
                touchScreenData = runtimeConfigProvider.getData(RuntimeConfigProvider.PREFERENCES_SCREEN_TOUCH_DATA, "[]");
                JsonArray jsonArray = JsonParser.parseString(touchScreenData).getAsJsonArray();
                TouchDefultData touchDefultData = ModelTouchBuilder.buildTouchDefault("onDown", DateUtils.formatterLocalDateTime(new Date()));
                jsonArray.add(new Gson().toJsonTree(touchDefultData));
                Groobee.getInstance().runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_SCREEN_TOUCH_DATA, jsonArray.toString());
                editor.apply();
            }
            return false;
        }

        @Override
        public void onShowPress(MotionEvent motionEvent) {
            /**100ms 정도 터치되면 발생**/
            isViewGoods = sharedPreferences.getBoolean(RuntimeConfigProvider.PREFERENCES_IS_VIEW_GOODS, false);

            if (isViewGoods) {
                touchScreenData = runtimeConfigProvider.getData(RuntimeConfigProvider.PREFERENCES_SCREEN_TOUCH_DATA, "[]");
                JsonArray jsonArray = JsonParser.parseString(touchScreenData).getAsJsonArray();
                TouchDefultData touchDefultData = ModelTouchBuilder.buildTouchDefault("onShowPress", DateUtils.formatterLocalDateTime(new Date()));
                jsonArray.add(new Gson().toJsonTree(touchDefultData));
                Groobee.getInstance().runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_SCREEN_TOUCH_DATA, jsonArray.toString());
                editor.apply();
            }
        }

        @Override
        public boolean onSingleTapUp(MotionEvent motionEvent) {
            /**172ms 이후에 손을 떼면 발생(onLongPress 발생전에 떼면 발생함.)**/
            isViewGoods = sharedPreferences.getBoolean(RuntimeConfigProvider.PREFERENCES_IS_VIEW_GOODS, false);

            if (isViewGoods) {
                touchScreenData = runtimeConfigProvider.getData(RuntimeConfigProvider.PREFERENCES_SCREEN_TOUCH_DATA, "[]");
                JsonArray jsonArray = JsonParser.parseString(touchScreenData).getAsJsonArray();
                TouchDefultData touchDefultData = ModelTouchBuilder.buildTouchDefault("onSingleTapUp", DateUtils.formatterLocalDateTime(new Date()));
                jsonArray.add(new Gson().toJsonTree(touchDefultData));
                Groobee.getInstance().runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_SCREEN_TOUCH_DATA, jsonArray.toString());
                editor.apply();
            }
            return false;
        }

        @Override
        public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent1, float distanceX, float distanceY) {
            /**최소 30ms 이후부터 onScroll 이벤트가 발생할 수 있으며, 플링시키지 않고 살며시 손을 떼면
             끝까지 onScroll 이벤트가 연속으로 발생한다.**/
            return false;
        }

        @Override
        public void onLongPress(MotionEvent motionEvent) {
            /**590~600ms 정도에 발생(길게 누를때). 이때 onSingleTabUp은 발생하지 않는다.**/
            isViewGoods = sharedPreferences.getBoolean(RuntimeConfigProvider.PREFERENCES_IS_VIEW_GOODS, false);

            if (isViewGoods) {
                touchScreenData = runtimeConfigProvider.getData(RuntimeConfigProvider.PREFERENCES_SCREEN_TOUCH_DATA, "[]");
                JsonArray jsonArray = JsonParser.parseString(touchScreenData).getAsJsonArray();
                TouchDefultData touchDefultData = ModelTouchBuilder.buildTouchDefault("onLongPress", DateUtils.formatterLocalDateTime(new Date()));
                jsonArray.add(new Gson().toJsonTree(touchDefultData));
                Groobee.getInstance().runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_SCREEN_TOUCH_DATA, jsonArray.toString());
                editor.apply();
            }
        }

        @Override
        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent1, float velocityX, float velocityY) {
            /**onScroll과 유사하지만 마지막에 손가락을 튕기면 플링으로 인식**/
            isViewGoods = sharedPreferences.getBoolean(RuntimeConfigProvider.PREFERENCES_IS_VIEW_GOODS, false);

            if (isViewGoods) {
                touchScreenData = runtimeConfigProvider.getData(RuntimeConfigProvider.PREFERENCES_SCREEN_TOUCH_DATA, "[]");
                JsonArray jsonArray = JsonParser.parseString(touchScreenData).getAsJsonArray();
                TouchFlingData touchFlingData = ModelTouchBuilder.buildTouchFling("onFling", DateUtils.formatterLocalDateTime(new Date()));
                jsonArray.add(new Gson().toJsonTree(touchFlingData));
                Groobee.getInstance().runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_SCREEN_TOUCH_DATA, jsonArray.toString());
                editor.apply();
            }
            return false;
        }
    }

    public void logSessionStarted() {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        RequestParams requestParams = ModelBuilder.serviceSessionState(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId
                                , memberId, "ASS", false);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");
                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging call logSessionStarted", e);
                }
            }
        });
    }

    public void logSessionEnded() {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        RequestParams requestParams = ModelBuilder.serviceSessionState(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId
                                , memberId, "ASE", false);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");
                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging call logSessionEnded", e);
                }
            }
        });
    }

    public void logSessionTerminate() {
        workingThreadSmall.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    runtimeConfigProvider.addData(editor, RuntimeConfigProvider.PREFERENCES_SESSION, false);
                    editor.apply();

                    if (getInstance().isAuth) {
                        String userId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_USER_ID, null);
                        String memberId = sharedPreferences.getString(RuntimeConfigProvider.PREFERENCES_MEMBER_ID, null);

                        if (StringUtils.isNullOrEmpty(userId))
                            userId = getCookieId();

                        RequestParams requestParams = ModelBuilder.serviceSessionState(groobeeConfigProvider.getGroobeeApiKey(), getCookieId(), userId
                                , memberId, "ASE", true);
                        JSONObject request = new JSONObject(new Gson().toJson(requestParams));
                        groobeeServiceManager.sendRequest(getInstance().urlService + ServicesConstants.SERVICE_API_APP_CAMPAIGN, request);
                    } else
                        LoggerUtils.w(TAG, "Authentication failure. Check the Service Key and PackageName in SDK configuration.");
                } catch (Exception e) {
                    LoggerUtils.w(TAG, "Error logging call logSessionTerminate", e);
                }
            }
        });
    }

}