package com.groobee.message.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;

import java.util.List;

public class PackageUtils {
    private static final String TAG = LoggerUtils.getClassLogTag(PackageUtils.class);
    private static String packageName;

    public PackageUtils() {
    }

    public static void setResourcePackageName(String packageName) {
        if (!StringUtils.isNullOrBlank(packageName)) {
            PackageUtils.packageName = packageName;
        } else {
            LoggerUtils.e(TAG, "Package name may not be null or blank");
        }

    }

    public static String getResourcePackageName(Context context) {
        if (packageName == null) {
            packageName = context.getPackageName();
        }
        return packageName;
    }

    public static String getCurrentPackageName(Context context) {
        ActivityManager manager = (ActivityManager) context.getSystemService( Activity.ACTIVITY_SERVICE );
        List<ActivityManager.RunningTaskInfo> list = manager.getRunningTasks(1);
        ActivityManager.RunningTaskInfo info = list.get(0);
        return info.topActivity.getClassName();
    }
}
