package com.groobee.message.common;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpLoader {
    public static Bitmap getBitmapImage(String url) {
        final Bitmap[] bitmap = new Bitmap[1];

        Thread thread = new Thread() {
            @Override
            public void run() {
            try {
                HttpURLConnection conn = (HttpURLConnection) new URL(url).openConnection();
                conn.setDoInput(true);
                conn.connect();

                InputStream is = conn.getInputStream();
                bitmap[0] = BitmapFactory.decodeStream(is);
            } catch (Exception e) {
                e.printStackTrace();
                bitmap[0] = null;
            }
            }
        };
        thread.start();

        try { thread.join(); }
        catch (InterruptedException e) { e.printStackTrace(); }

        return bitmap[0];
    }

    public static boolean isAuthConnection(String url, JSONObject request) {
        final boolean[] result = {false};

        Thread thread = new Thread() {
            @Override
            public void run() {
            try {
                HttpURLConnection conn = (HttpURLConnection) new URL(url).openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json; utf-8");
                conn.setRequestProperty("Accept", "application/json");
                conn.setDoInput(true);

                try(OutputStream outputStream = conn.getOutputStream()) {
                    byte[] input = request.toString().getBytes("utf-8");
                    outputStream.write(input, 0, input.length);
                }

                StringBuilder sb = new StringBuilder();
                try(BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"))) {
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line.trim());
                    }
                }

                JsonObject response = (JsonObject) JsonParser.parseString(sb.toString());
                result[0] = response.get("resultCode").getAsString().equals("success");

            } catch (Exception e) {
                e.printStackTrace();
            }
            }
        };
        thread.start();

        try { thread.join(); }
        catch (InterruptedException e) { e.printStackTrace(); }

        return result[0];
    }
}
