/*
 * Decompiled with CFR 0.152.
 */
package com.greymass.esr.models;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.greymass.esr.models.AccountName;
import com.greymass.esr.models.PermissionName;
import com.greymass.esr.util.JSONUtil;
import java.util.HashMap;
import java.util.Map;

public class PermissionLevel {
    public static String ACTOR = "actor";
    public static String PERMISSION = "permission";
    private AccountName gAccountName;
    private PermissionName gPermissionName;

    public PermissionLevel() {
    }

    public PermissionLevel(AccountName accountName, PermissionName permissionName) {
        this.gAccountName = accountName;
        this.gPermissionName = permissionName;
    }

    public PermissionLevel(String accountName, String permissionName) {
        this.gAccountName = new AccountName(accountName);
        this.gPermissionName = new PermissionName(permissionName);
    }

    public PermissionLevel(JsonObject obj) {
        if (obj.has(PERMISSION)) {
            if (obj.get(PERMISSION).isJsonObject()) {
                obj = obj.getAsJsonObject(PERMISSION);
            } else if (obj.get(PERMISSION).isJsonNull()) {
                return;
            }
        }
        this.gAccountName = new AccountName(obj.get(ACTOR).getAsString());
        this.gPermissionName = new PermissionName(obj.get(PERMISSION).getAsString());
    }

    public Map<String, String> toMap() {
        if (this.gAccountName == null || this.gPermissionName == null) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        map.put(ACTOR, this.gAccountName == null ? null : this.gAccountName.getName());
        map.put(PERMISSION, this.gPermissionName == null ? null : this.gPermissionName.getName());
        return map;
    }

    public void setAccountName(AccountName accountName) {
        this.gAccountName = accountName;
    }

    public AccountName getAccountName() {
        return this.gAccountName;
    }

    public void setPermissionName(PermissionName permissionName) {
        this.gPermissionName = permissionName;
    }

    public PermissionName getPermissionName() {
        return this.gPermissionName;
    }

    public String toJSON() {
        return JSONUtil.stringify(this.toMap());
    }

    public String toString() {
        return this.toJSON();
    }
}

