/*
 * Decompiled with CFR 0.152.
 */
package com.greymass.esr.models;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.greymass.esr.ESRException;
import com.greymass.esr.models.Chain;
import java.util.ArrayList;
import java.util.List;

public class ChainId {
    public static final String CHAIN_ID = "chain_id";
    private static final String ALIAS_LABEL = "chain_alias";
    private String gChainId;
    private int gChainAlias;
    private String gChainName;

    public ChainId(Chain chain) {
        this.gChainId = chain.getId();
        this.gChainAlias = chain.getAlias();
        this.gChainName = chain.name().toLowerCase();
    }

    public ChainId(String chainId, int chainAlias, String chainName) {
        this.gChainId = chainId;
        this.gChainAlias = chainAlias;
        this.gChainName = chainName;
    }

    public String getChainId() {
        return this.gChainId;
    }

    public int getChainAlias() {
        return this.gChainAlias;
    }

    public String getChainName() {
        return this.gChainName;
    }

    public static ChainId fromVariant(JsonArray variant) throws ESRException {
        if (ALIAS_LABEL.equals(variant.get(0).getAsString())) {
            int alias = variant.get(1).getAsInt();
            Chain chain = Chain.fromChainAlias(alias);
            if (chain == Chain.UNKNOWN) {
                throw new ESRException("Cannont create ChainId from variant, chain alias unknown");
            }
            return new ChainId(chain);
        }
        String id = variant.get(1).getAsString();
        Chain chain = Chain.fromChainId(id);
        if (chain == Chain.UNKNOWN) {
            return new ChainId(id, Chain.UNKNOWN.getAlias(), Chain.UNKNOWN.name());
        }
        return new ChainId(chain);
    }

    public List<Object> toVariant() {
        if (this.gChainAlias != Chain.UNKNOWN.getAlias()) {
            ArrayList variant = Lists.newArrayList();
            variant.add(ALIAS_LABEL);
            variant.add(this.gChainAlias);
            return variant;
        }
        ArrayList variant = Lists.newArrayList();
        variant.add(CHAIN_ID);
        variant.add(this.gChainId);
        return variant;
    }
}

