/*
 * Decompiled with CFR 0.152.
 */
package com.greymass.esr.models;

import com.google.gson.JsonObject;
import com.greymass.esr.ESRException;
import com.greymass.esr.util.JSONUtil;
import java.util.Map;

public class ActionData {
    private Map<String, Object> gData;
    private String gPackedData;

    public ActionData(String data) {
        this.gPackedData = data;
    }

    public ActionData(Map<String, Object> data) {
        this.gData = data;
    }

    public ActionData(JsonObject data) {
        this.gData = JSONUtil.objectToMap(data);
    }

    public boolean isPacked() {
        return this.gPackedData != null;
    }

    public void setData(Map<String, Object> data) {
        this.gData = data;
        this.gPackedData = null;
    }

    public void setData(String packedData) {
        this.gPackedData = packedData;
        this.gData = null;
    }

    public Map<String, Object> getData() {
        return this.gData;
    }

    public String getPackedData() {
        return this.gPackedData;
    }

    public String toJSON() throws ESRException {
        if (this.isPacked()) {
            throw new ESRException("Cannot toJSON packed action data");
        }
        return JSONUtil.stringify(this.gData);
    }

    public String toString() {
        try {
            return this.isPacked() ? this.getPackedData() : this.toJSON();
        }
        catch (ESRException e) {
            return "Failed to toJSON - " + e.getMessage();
        }
    }
}

