/*
 * Decompiled with CFR 0.152.
 */
package com.greymass.esr.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONUtil {
    private static final Gson gGson;

    public static String stringify(Object toEncode) {
        return gGson.toJson(toEncode);
    }

    public static Object parse(JsonElement element) {
        if (element.isJsonObject()) {
            return JSONUtil.objectToMap((JsonObject)element);
        }
        if (element.isJsonArray()) {
            return JSONUtil.arrayToList((JsonArray)element);
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
        }
        return null;
    }

    public static Map<String, Object> objectToMap(JsonObject object) {
        HashMap result = Maps.newHashMap();
        for (String property : object.keySet()) {
            result.put(property, JSONUtil.parse(object.get(property)));
        }
        return result;
    }

    public static List<Object> arrayToList(JsonArray array) {
        ArrayList result = Lists.newArrayList();
        for (JsonElement element : array) {
            result.add(JSONUtil.parse(element));
        }
        return result;
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        gGson = builder.create();
    }
}

