/*
 * Decompiled with CFR 0.152.
 */
package com.greymass.esr.models;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.BaseEncoding;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.greymass.esr.ESRException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.text.Charsets;

public class InfoPair {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private String gKey;
    private String gHexValue;

    public InfoPair(String key, String value) {
        this.gKey = key;
        this.gHexValue = value;
    }

    public String getKey() {
        return this.gKey;
    }

    public String getHexValue() {
        return this.gHexValue;
    }

    public String getStringValue() {
        return new String(this.getBytesValue(), Charsets.UTF_8);
    }

    public byte[] getBytesValue() {
        return BaseEncoding.base16().decode((CharSequence)this.gHexValue);
    }

    public static InfoPair fromDeserializedJsonObject(JsonObject obj) throws ESRException {
        String key = obj.get(KEY).getAsString();
        JsonElement value = obj.get(VALUE);
        if (value.getAsJsonPrimitive().isString()) {
            return new InfoPair(key, value.getAsString());
        }
        throw new ESRException("InfoPair value should always be a hex string when deserializing");
    }

    public static List<InfoPair> listFromDeserializedJsonArray(JsonArray pairs) throws ESRException {
        ArrayList infoPairs = Lists.newArrayList();
        for (JsonElement el : pairs) {
            if (!(el instanceof JsonObject)) {
                throw new ESRException("Info pairs must be objects");
            }
            infoPairs.add(InfoPair.fromDeserializedJsonObject((JsonObject)el));
        }
        return infoPairs;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap pair = Maps.newLinkedHashMap();
        pair.put(KEY, this.gKey);
        pair.put(VALUE, this.gHexValue);
        return pair;
    }

    public void setHexValue(String hexValue) {
        this.gHexValue = hexValue;
    }
}

