/*
 * Decompiled with CFR 0.152.
 */
package com.greymass.esr.models;

import com.google.gson.JsonArray;
import com.greymass.esr.ESRException;
import com.greymass.esr.interfaces.IRequest;
import com.greymass.esr.models.Action;
import com.greymass.esr.models.Actions;
import com.greymass.esr.models.Identity;
import com.greymass.esr.models.PermissionLevel;
import com.greymass.esr.models.Transaction;

public class IRequestFactory {
    public static IRequest fromVariant(JsonArray variant) throws ESRException {
        String variantType;
        switch (variantType = variant.get(0).getAsString()) {
            case "action": {
                return new Action(variant.get(1).getAsJsonObject());
            }
            case "action[]": {
                return new Actions(variant.get(1).getAsJsonArray());
            }
            case "transaction": {
                return new Transaction(variant.get(1).getAsJsonObject());
            }
            case "identity": {
                return new Identity(new PermissionLevel(variant.get(1).getAsJsonObject()));
            }
        }
        throw new ESRException("Unknown request variant type: " + variantType);
    }
}

