/*
 * Decompiled with CFR 0.152.
 */
package com.greymass.esr.models;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.greymass.esr.ESRException;
import com.greymass.esr.interfaces.IRequest;
import com.greymass.esr.models.Action;
import com.greymass.esr.models.Actions;
import com.greymass.esr.models.Extension;
import com.greymass.esr.models.TransactionHeader;
import com.greymass.esr.util.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Transaction
extends TransactionHeader
implements IRequest {
    public static final String VARIANT_TYPE = "transaction";
    public static final String EXPIRATION = "expiration";
    public static final String REF_BLOCK_NUM = "ref_block_num";
    public static final String MAX_NET_USAGE_WORDS = "max_net_usage_words";
    public static final String REF_BLOCK_PREFIX = "ref_block_prefix";
    public static final String MAX_CPU_USAGE_MS = "max_cpu_usage_ms";
    public static final String DELAY_SEC = "delay_sec";
    private static final String CONTEXT_FREE_ACTIONS = "context_free_actions";
    private static final String ACTIONS = "actions";
    private static final String TRANSACTION_EXTENSIONS = "transaction_extensions";
    private List<Action> gContextFreeActions = Lists.newArrayList();
    private List<Action> gActions = Lists.newArrayList();
    private List<Extension> gTransactionExtensions = Lists.newArrayList();

    public Transaction() {
    }

    public Transaction(String expiration, Long refBlockNum, Long refBlockPrefix, int maxNetUsageWords, int maxCpuUsageMs, int delaySec, List<Action> contextFreeActions, List<Action> actions, List<Extension> transactionExtensions) {
        super(expiration, refBlockNum, refBlockPrefix, maxNetUsageWords, maxCpuUsageMs, delaySec);
        this.gContextFreeActions = contextFreeActions;
        this.gActions = actions;
        this.gTransactionExtensions = transactionExtensions;
    }

    public Transaction(JsonObject obj) throws ESRException {
        super(obj.get(EXPIRATION).getAsString(), obj.get(REF_BLOCK_NUM).getAsLong(), obj.get(REF_BLOCK_PREFIX).getAsLong(), obj.get(MAX_NET_USAGE_WORDS).getAsInt(), obj.get(MAX_CPU_USAGE_MS).getAsInt(), obj.get(DELAY_SEC).getAsInt());
        this.gContextFreeActions = new Actions(obj.getAsJsonArray(CONTEXT_FREE_ACTIONS)).getActions();
        this.gActions = new Actions(obj.getAsJsonArray(ACTIONS)).getActions();
        this.gTransactionExtensions = Transaction.makeExtensionList(obj.getAsJsonArray(TRANSACTION_EXTENSIONS));
    }

    public Transaction shallowClone() {
        Transaction cloned = new Transaction();
        cloned.setExpiration(this.getExpiration());
        cloned.setRefBlockNum(this.getRefBlockNum());
        cloned.setRefBlockPrefix(this.getRefBlockPrefix());
        cloned.setMaxCpuUsageMs(this.getMaxCpuUsageMs());
        cloned.setMaxNetUsageWords(this.getMaxNetUsageWords());
        cloned.setContextFreeActions(this.getContextFreeActionsList());
        cloned.setActions(this.getActionsList());
        cloned.setTransactionExtensions(this.getTransactionExtensions());
        return cloned;
    }

    public List<Action> getContextFreeActionsList() {
        return this.gContextFreeActions;
    }

    public void setContextFreeActions(List<Action> contextFreeActions) {
        this.gContextFreeActions = contextFreeActions;
    }

    public List<Action> getActionsList() {
        return this.gActions;
    }

    public void setActions(List<Action> actions) {
        this.gActions = actions;
    }

    public List<Extension> getTransactionExtensions() {
        return this.gTransactionExtensions;
    }

    public void setTransactionExtensions(List<Extension> transactionExtensions) {
        this.gTransactionExtensions = transactionExtensions;
    }

    private static List<Extension> makeExtensionList(JsonArray array) throws ESRException {
        ArrayList extensions = Lists.newArrayList();
        for (JsonElement el : array) {
            if (!(el instanceof JsonObject)) {
                throw new ESRException("Extensions should be an object");
            }
            JsonObject obj = (JsonObject)el;
            extensions.add(new Extension(obj));
        }
        return extensions;
    }

    @Override
    public List<Action> getRawActions() {
        return this.getActionsList();
    }

    @Override
    public List<Object> toVariant() {
        ArrayList variant = Lists.newArrayList();
        variant.add(VARIANT_TYPE);
        variant.add(this.toMap());
        return variant;
    }

    public String toJSON() {
        return JSONUtil.stringify(this.toMap());
    }

    public String toString() {
        return this.toJSON();
    }

    private Map<String, Object> toMap() {
        HashMap transactionMap = Maps.newHashMap();
        transactionMap.put(EXPIRATION, this.getExpiration());
        transactionMap.put(REF_BLOCK_NUM, this.getRefBlockNum());
        transactionMap.put(REF_BLOCK_PREFIX, this.getRefBlockPrefix());
        transactionMap.put(MAX_NET_USAGE_WORDS, this.getMaxNetUsageWords());
        transactionMap.put(MAX_CPU_USAGE_MS, this.getMaxCpuUsageMs());
        transactionMap.put(DELAY_SEC, this.getDelaySec());
        ArrayList contextFreeActionMaps = Lists.newArrayList();
        for (Action action : this.gContextFreeActions) {
            contextFreeActionMaps.add(action.toMap());
        }
        transactionMap.put(CONTEXT_FREE_ACTIONS, contextFreeActionMaps);
        ArrayList actionMaps = Lists.newArrayList();
        for (Action action : this.gActions) {
            actionMaps.add(action.toMap());
        }
        transactionMap.put(ACTIONS, actionMaps);
        ArrayList arrayList = Lists.newArrayList();
        for (Extension extension : this.gTransactionExtensions) {
            arrayList.add(extension.toMap());
        }
        transactionMap.put(TRANSACTION_EXTENSIONS, arrayList);
        return transactionMap;
    }

    public boolean hasTapos() {
        return !"1970-01-01T00:00:00.000".equals(this.getExpiration()) || this.getRefBlockNum() != 0L || this.getRefBlockPrefix() != 0L;
    }
}

