/*
 * Decompiled with CFR 0.152.
 */
package com.greymass.esr;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Bytes;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.greymass.esr.ESR;
import com.greymass.esr.ESRException;
import com.greymass.esr.ESRV8Runtime;
import com.greymass.esr.ResolvedSigningRequest;
import com.greymass.esr.ResourceReader;
import com.greymass.esr.interfaces.IAbiProvider;
import com.greymass.esr.interfaces.IRequest;
import com.greymass.esr.interfaces.ISignatureProvider;
import com.greymass.esr.models.AccountName;
import com.greymass.esr.models.Action;
import com.greymass.esr.models.Actions;
import com.greymass.esr.models.ChainId;
import com.greymass.esr.models.IRequestFactory;
import com.greymass.esr.models.Identity;
import com.greymass.esr.models.InfoPair;
import com.greymass.esr.models.PermissionLevel;
import com.greymass.esr.models.PermissionName;
import com.greymass.esr.models.RequestFlag;
import com.greymass.esr.models.Signature;
import com.greymass.esr.models.Transaction;
import com.greymass.esr.models.TransactionContext;
import com.greymass.esr.util.CompressionUtil;
import com.greymass.esr.util.JSONUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;

public class SigningRequest {
    public static final int PROTOCOL_VERSION = 2;
    public static final String PLACEHOLDER_NAME = "............1";
    public static final String PLACEHOLDER_PERMISSION = "............2";
    public static final PermissionLevel PLACEHOLDER_PERMISSION_LEVEL = new PermissionLevel("............1", "............2");
    public static final String PLACEHOLDER_PACKED = "0101000000000000000200000000000000";
    private static final String REQ = "req";
    private static final String FLAGS = "flags";
    private static final String CALLBACK = "callback";
    private static final String INFO = "info";
    private static final String SIG = "sig";
    private IAbiProvider gAbiProvider;
    private ESRV8Runtime gRuntime;
    private ResourceReader gResourceReader;
    private ESR gESR;
    private ChainId gChainId;
    private IRequest gRequest;
    private RequestFlag gRequestFlag;
    private String gCallback;
    private List<InfoPair> gInfoPairs;
    private Signature gSignature;

    public SigningRequest(ESR esr) {
        this.gESR = esr;
        this.gResourceReader = esr.getResourceReader();
        this.gAbiProvider = esr.getAbiProvider();
        this.gRuntime = esr.getRuntime();
        this.gChainId = ChainId.EOS;
        this.gRequestFlag = RequestFlag.getDefault();
        this.gCallback = "";
        this.gInfoPairs = Lists.newArrayList();
    }

    public SigningRequest load(String uri) throws ESRException {
        String[] parts = uri.split(":");
        String prefix = parts[0];
        String path = parts[1];
        if (!prefix.equals("esr") && !prefix.equals("web+esr")) {
            throw new ESRException("Only esr and web+esr schemes are supported");
        }
        if (path.startsWith("//")) {
            path = path.substring(2);
        }
        byte[] decoded = this.gRuntime.base64uDecode(path);
        return this.load(decoded);
    }

    SigningRequest load(byte[] data) throws ESRException {
        int header = data[0] & 0xFF;
        int version = header & 0xFFFFFF7F;
        if (version != 2) {
            throw new ESRException("Unsupported protocol version");
        }
        byte[] reqArray = Arrays.copyOfRange(data, 1, data.length);
        if ((header & 0x80) != 0) {
            try {
                reqArray = CompressionUtil.decompressByteArray(reqArray);
            }
            catch (IOException | DataFormatException e) {
                e.printStackTrace();
                throw new ESRException("Failed to decompress request: " + e.getMessage());
            }
        }
        String requestJson = this.gRuntime.deserializeSigningRequest(reqArray);
        JsonObject result = (JsonObject)JsonParser.parseString((String)requestJson);
        JsonObject request = result.getAsJsonObject(REQ);
        this.gChainId = ChainId.fromVariant(request.getAsJsonArray("chain_id"));
        this.gRequest = IRequestFactory.fromVariant(request.getAsJsonArray(REQ));
        this.gRequestFlag = new RequestFlag(request.get(FLAGS).getAsByte());
        this.gCallback = request.get(CALLBACK).getAsString();
        this.gInfoPairs = InfoPair.listFromDeserializedJsonArray(request.get(INFO).getAsJsonArray());
        if (result.has(SIG) && result.get(SIG).isJsonObject()) {
            this.gSignature = new Signature(result.getAsJsonObject(SIG));
        }
        return this;
    }

    public void setRequest(Action action) throws ESRException {
        if (!action.getData().isPacked()) {
            this.gRuntime.serializeActionData(this.gAbiProvider, action);
        }
        this.gRequest = action;
    }

    public void setRequest(Actions actions) throws ESRException {
        for (Action action : actions.getActions()) {
            if (action.getData().isPacked()) continue;
            this.gRuntime.serializeActionData(this.gAbiProvider, action);
        }
        this.gRequest = actions;
    }

    public void setRequest(Transaction transaction) throws ESRException {
        for (Action action : transaction.getActionsList()) {
            if (action.getData().isPacked()) continue;
            this.gRuntime.serializeActionData(this.gAbiProvider, action);
        }
        for (Action action : transaction.getContextFreeActionsList()) {
            if (action.getData().isPacked()) continue;
            this.gRuntime.serializeActionData(this.gAbiProvider, action);
        }
        this.gRequest = transaction;
    }

    public void setRequest(Identity identity) {
        this.gRequest = identity;
    }

    public void setSignature(Signature signature) {
        this.gSignature = signature;
    }

    public boolean isIdentity() {
        return this.gRequest != null && this.gRequest instanceof Identity;
    }

    public String getIdentity() {
        if (this.isIdentity() && ((Identity)this.gRequest).getPermissionLevel() != null) {
            AccountName accountName = ((Identity)this.gRequest).getPermissionLevel().getAccountName();
            if (accountName == null) {
                return null;
            }
            String actor = accountName.getName();
            return PLACEHOLDER_NAME.equals(actor) ? null : actor;
        }
        return null;
    }

    public String getIdentityPermission() {
        if (this.isIdentity() && ((Identity)this.gRequest).getPermissionLevel() != null) {
            PermissionName permissionName = ((Identity)this.gRequest).getPermissionLevel().getPermissionName();
            if (permissionName == null) {
                return null;
            }
            String permission = permissionName.getName();
            return PLACEHOLDER_NAME.equals(permission) ? null : permission;
        }
        return null;
    }

    public boolean hasSignature() {
        return this.gSignature != null;
    }

    public Signature getSignature() {
        return this.gSignature;
    }

    public void sign(ISignatureProvider signatureProvider) {
        this.setSignature(signatureProvider.sign(this.getSignatureDigestAsHex()));
    }

    public String encode() {
        return this.encode(true, true);
    }

    public String encode(boolean compress, boolean slashes) {
        byte[] compressed;
        byte header = 2;
        byte[] data = this.getData();
        byte[] sigData = this.getSignatureData();
        byte[] toEncode = Bytes.concat((byte[][])new byte[][]{data, sigData});
        if (compress && toEncode.length > (compressed = CompressionUtil.compressByteArray(toEncode)).length) {
            header = (byte)(header | 0x80);
            toEncode = compressed;
        }
        byte[] out = Bytes.concat((byte[][])new byte[][]{{header}, toEncode});
        String scheme = "esr:";
        if (slashes) {
            scheme = scheme + "//";
        }
        return scheme + this.gRuntime.base64uEncode(out);
    }

    public List<Action> resolveActions() throws ESRException {
        return this.resolveActions(this.fetchAbis());
    }

    public List<Action> resolveActions(PermissionLevel signer) throws ESRException {
        return this.resolveActions(this.fetchAbis(), signer);
    }

    public List<Action> resolveActions(Map<String, String> abiMap) throws ESRException {
        return this.resolveActions(abiMap, null);
    }

    public List<Action> resolveActions(Map<String, String> abiMap, PermissionLevel signer) throws ESRException {
        List<Action> rawActions = this.getRawActions();
        ArrayList resolvedActions = Lists.newArrayList();
        for (Action raw2 : rawActions) {
            resolvedActions.add(this.gRuntime.getResolvedAction(abiMap, signer, raw2));
        }
        return resolvedActions;
    }

    public Transaction resolveTransaction(PermissionLevel signer) throws ESRException {
        return this.resolveTransaction(this.fetchAbis(), signer);
    }

    public Transaction resolveTransaction(PermissionLevel signer, TransactionContext transactionContext) throws ESRException {
        return this.resolveTransaction(this.fetchAbis(), signer, transactionContext);
    }

    public Transaction resolveTransaction(Map<String, String> abiMap, PermissionLevel signer) throws ESRException {
        return this.resolveTransaction(abiMap, signer, new TransactionContext());
    }

    public Transaction resolveTransaction(Map<String, String> abiMap, PermissionLevel signer, TransactionContext transactionContext) throws ESRException {
        Transaction transaction = this.getRawTransaction();
        if (!(this.gRequest instanceof Identity) && !transaction.hasTapos()) {
            if (transactionContext.getExpiration() != null && transactionContext.getRefBlockNum() != null && transactionContext.getRefBlockPrefix() != null) {
                transaction.setExpiration(transactionContext.getExpiration());
                transaction.setRefBlockNum(transactionContext.getRefBlockNum());
                transaction.setRefBlockPrefix(transactionContext.getRefBlockPrefix());
            } else if (transactionContext.getBlockNum() != null && transactionContext.getRefBlockPrefix() != null && transactionContext.getTimestamp() != null) {
                this.gRuntime.setTransactionFromContext(transaction, transactionContext);
            } else {
                throw new ESRException("Invalid transaction context, need either a reference block or explicit TAPoS values");
            }
        }
        List<Action> actions = this.resolveActions(abiMap, signer);
        Transaction resolved = transaction.shallowClone();
        resolved.setActions(actions);
        return resolved;
    }

    public ResolvedSigningRequest resolve(PermissionLevel signer, TransactionContext transactionContext) throws ESRException {
        return this.resolve(this.fetchAbis(), signer, transactionContext);
    }

    public ResolvedSigningRequest resolve(Map<String, String> abiMap, PermissionLevel signer, TransactionContext transactionContext) throws ESRException {
        Transaction transaction = this.resolveTransaction(signer, transactionContext);
        for (Action action : transaction.getActionsList()) {
            this.gRuntime.serializeActionData(this.gAbiProvider, action);
        }
        byte[] serializedTransaction = this.gRuntime.serializeTransaction(transaction.toJSON());
        return new ResolvedSigningRequest(this, signer, transaction, serializedTransaction);
    }

    public Transaction getRawTransaction() throws ESRException {
        if (this.gRequest == null) {
            throw new ESRException("Cannot get raw transaction, request is not set");
        }
        if (this.gRequest instanceof Transaction) {
            return (Transaction)this.gRequest;
        }
        Transaction transaction = new Transaction();
        transaction.setActions(this.getRawActions());
        return transaction;
    }

    public List<Action> getRawActions() {
        if (this.gRequest instanceof Identity) {
            return Lists.newArrayList((Object[])new Action[]{this.gRuntime.identityToAction((Identity)this.gRequest)});
        }
        return this.gRequest.getRawActions();
    }

    public List<String> getRequiredAbis() {
        ArrayList accounts = Lists.newArrayList();
        for (Action action : this.getRawActions()) {
            if (action.isIdentity()) continue;
            accounts.add(action.getAccount().getName());
        }
        return accounts;
    }

    public Map<String, String> fetchAbis() throws ESRException {
        HashMap abiMap = Maps.newHashMap();
        for (String accountName : this.getRequiredAbis()) {
            abiMap.put(accountName, this.gAbiProvider.getAbi(accountName));
        }
        return abiMap;
    }

    public ChainId getChainId() {
        return this.gChainId;
    }

    public void setChainId(ChainId chainId) {
        this.gChainId = chainId;
    }

    public byte[] getData() {
        return this.gRuntime.serializeSigningRequest(this.toDataJSON());
    }

    public byte[] getSignatureData() {
        if (this.gSignature == null) {
            return new byte[0];
        }
        return this.gRuntime.getSignatureData(this.gSignature);
    }

    public String getSignatureDigestAsHex() {
        return this.gRuntime.getSignatureDigestAsHex(2, this.getData());
    }

    public IRequest getRequest() {
        return this.gRequest;
    }

    public String getCallback() {
        return this.gCallback;
    }

    public void setCallback(String callback) {
        this.gCallback = callback;
    }

    public RequestFlag getRequestFlag() {
        return this.gRequestFlag;
    }

    public void setRequestFlag(RequestFlag requestFlag) {
        this.gRequestFlag = requestFlag;
    }

    public void setInfoKey(String key, Object value) throws ESRException {
        String hexValue;
        if (key == null) {
            throw new ESRException("Key cannot be null");
        }
        if (value instanceof String) {
            String stringVal = (String)value;
            hexValue = BaseEncoding.base16().encode(stringVal.getBytes());
        } else if (value instanceof Boolean) {
            byte[] byArray;
            boolean booleanValue = (Boolean)value;
            BaseEncoding baseEncoding = BaseEncoding.base16();
            if (booleanValue) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 1;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 0;
            }
            hexValue = baseEncoding.encode(byArray);
        } else {
            throw new ESRException("Can only setInfoKey with string or boolean");
        }
        for (InfoPair pair : this.gInfoPairs) {
            if (!key.equals(pair.getKey())) continue;
            pair.setHexValue(hexValue);
            return;
        }
        this.gInfoPairs.add(new InfoPair(key, hexValue));
    }

    public List<InfoPair> getInfoPairs() {
        return this.gInfoPairs;
    }

    public Map<String, byte[]> getRawInfo() {
        LinkedHashMap rawInfo = Maps.newLinkedHashMap();
        for (InfoPair pair : this.gInfoPairs) {
            rawInfo.put(pair.getKey(), pair.getBytesValue());
        }
        return rawInfo;
    }

    public Map<String, String> getInfo() {
        LinkedHashMap info = Maps.newLinkedHashMap();
        for (InfoPair pair : this.gInfoPairs) {
            info.put(pair.getKey(), pair.getStringValue());
        }
        return info;
    }

    public void addInfoPair(InfoPair infoPair) {
        this.gInfoPairs.add(infoPair);
    }

    public void setInfoPairs(List<InfoPair> infoPairs) {
        this.gInfoPairs = infoPairs;
    }

    public String toDataJSON() {
        HashMap toEncode = Maps.newHashMap();
        toEncode.put("chain_id", this.gChainId.toVariant());
        toEncode.put(REQ, this.gRequest.toVariant());
        toEncode.put(FLAGS, this.gRequestFlag.getFlagValue());
        toEncode.put(CALLBACK, this.gCallback);
        ArrayList info = Lists.newArrayList();
        for (InfoPair pair : this.gInfoPairs) {
            info.add(pair.toMap());
        }
        toEncode.put(INFO, info);
        return JSONUtil.stringify(toEncode);
    }

    public SigningRequest copy() throws ESRException {
        SigningRequest copy = new SigningRequest(this.gESR);
        copy.load(this.encode());
        return copy;
    }
}

