/*
 * Decompiled with CFR 0.152.
 */
package com.greymass.esr;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.BaseEncoding;
import com.greymass.esr.ESRException;
import com.greymass.esr.SigningRequest;
import com.greymass.esr.models.PermissionLevel;
import com.greymass.esr.models.ResolvedCallback;
import com.greymass.esr.models.Transaction;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResolvedSigningRequest {
    private SigningRequest gSigningRequest;
    private PermissionLevel gSigner;
    private Transaction gTransaction;
    private byte[] gSerializedTransaction;

    public ResolvedSigningRequest(SigningRequest request, PermissionLevel signer, Transaction transaction, byte[] serializedTransaction) {
        this.gSigningRequest = request;
        this.gSigner = signer;
        this.gTransaction = transaction;
        this.gSerializedTransaction = serializedTransaction;
    }

    public String getTransactionId() throws ESRException {
        try {
            byte[] sha256 = MessageDigest.getInstance("SHA-256").digest(this.gSerializedTransaction);
            return BaseEncoding.base16().encode(sha256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ESRException("Failed to get SHA256 message digest");
        }
    }

    public ResolvedCallback getCallback(List<String> signatures) throws ESRException {
        return this.getCallback(signatures, -1L);
    }

    public ResolvedCallback getCallback(List<String> signatures, long blockNum) throws ESRException {
        if (Strings.isNullOrEmpty((String)this.gSigningRequest.getCallback())) {
            throw new ESRException("Callback is null or empty");
        }
        HashMap payload = Maps.newHashMap();
        payload.put("SIG", signatures.get(0));
        payload.put("tx", this.getTransactionId());
        payload.put("rbn", this.gTransaction.getRefBlockNum().toString());
        payload.put("rid", this.gTransaction.getRefBlockPrefix().toString());
        payload.put("ex", this.gTransaction.getExpiration());
        payload.put("req", this.gSigningRequest.encode());
        payload.put("sa", this.gSigner.getAccountName().getName());
        payload.put("sp", this.gSigner.getPermissionName().getName());
        for (int i = 1; i < signatures.size(); ++i) {
            payload.put("SIG" + i, signatures.get(i));
        }
        if (blockNum != -1L) {
            payload.put("bn", Long.toString(blockNum));
        }
        Pattern pattern = Pattern.compile("(\\{\\{([a-z0-9]+)\\}\\})");
        Matcher matcher = pattern.matcher(this.gSigningRequest.getCallback());
        StringBuffer url = new StringBuffer(this.gSigningRequest.getCallback().length());
        while (matcher.find()) {
            String text = matcher.group(0);
            text = text.substring(2);
            matcher.appendReplacement(url, payload.containsKey(text = text.substring(0, text.length() - 2)) ? String.valueOf(payload.get(text)) : "");
        }
        matcher.appendTail(url);
        String callbackUrl = url.toString();
        return new ResolvedCallback(callbackUrl, this.gSigningRequest.getRequestFlag().isBackground(), payload);
    }
}

