/*
 * Decompiled with CFR 0.152.
 */
package com.greymass.esr;

import android.util.Log;
import com.eclipsesource.v8.JavaCallback;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8ArrayBuffer;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8TypedArray;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.greymass.esr.ESRException;
import com.greymass.esr.R;
import com.greymass.esr.ResourceReader;
import com.greymass.esr.SigningRequest;
import com.greymass.esr.interfaces.IAbiProvider;
import com.greymass.esr.models.AccountName;
import com.greymass.esr.models.Action;
import com.greymass.esr.models.ActionData;
import com.greymass.esr.models.ActionName;
import com.greymass.esr.models.Identity;
import com.greymass.esr.models.PermissionLevel;
import com.greymass.esr.models.Signature;
import com.greymass.esr.models.Transaction;
import com.greymass.esr.models.TransactionContext;
import com.greymass.esr.util.JSONUtil;
import java.nio.ByteBuffer;
import java.util.Map;

public class ESRV8Runtime {
    private static final String V8_TAG = "ESR-V8";
    private static final String UNDEFINED = "undefined";
    private V8 gRuntime;
    private ResourceReader gResourceReader;

    public ESRV8Runtime(ResourceReader resourceReader) {
        this.gResourceReader = resourceReader;
        this.gRuntime = V8.createV8Runtime((String)"global");
        this.gRuntime.executeVoidScript(this.gResourceReader.readResourceString(R.raw.serialize));
        this.injectConsole();
        this.injectEncoderDecoder();
        this.injectGetContract();
    }

    public byte[] base64uDecode(String b64data) {
        V8Array array = this.gRuntime.executeArrayScript(String.format("(function() {\nlet decoded = global.base64u.decode('%s')\nreturn decoded\n})()", b64data));
        return this.v8ArrayToByteArray(array);
    }

    public String base64uEncode(byte[] bytes) {
        return this.gRuntime.executeStringScript(String.format("(function() {\nlet decoded = global.base64u.encode(%s)\nreturn decoded\n})()", this.byteArrayToUnt8ScriptValue(bytes)));
    }

    public String deserializeSigningRequest(byte[] data) {
        String script = String.format("let array = Uint8Array.from(%s)\nconst textEncoder = {encode: global.encodeFunction}\nconst textDecoder = {decode: global.decodeFunction}\nconst buffer = new Serialize.SerialBuffer({\n    textEncoder,\n    textDecoder,\n    array,\n})\nconst req = AbiTypes.get('signing_request').deserialize(buffer)\nlet signature = global.abi.RequestSignature | undefined\nif (buffer.haveReadData()) {\n    const type = global.AbiTypes.get('request_signature')\n    signature = type.deserialize(buffer)\n}\nJSON.stringify({\n    req: req,\n    sig: signature\n})", JSONUtil.stringify(data));
        return this.gRuntime.executeStringScript(script);
    }

    public void serializeActionData(IAbiProvider abiProvider, Action action) throws ESRException {
        if (action.getData().isPacked()) {
            return;
        }
        String script = String.format("(function() {\nlet contract = " + (action.isIdentity() ? "global.getContract(global.abi)" : "global.getContract(" + abiProvider.getAbi(action.getAccount().getName()) + ")") + "\nlet serializedActionData = global.Serialize.serializeActionData(contract, '%s', '%s', %s, {encode: global.encodeFunction}, {decode: global.decodeFunction})\nreturn serializedActionData\n})()", action.getAccount().getName(), action.getName().getName(), action.getData().toJSON());
        String packed = this.gRuntime.executeStringScript(script);
        action.getData().setData(packed);
    }

    public byte[] serializeTransaction(String transactionJSON) {
        String script = String.format("(function() {\nconst textEncoder = {encode: global.encodeFunction}\nconst textDecoder = {decode: global.decodeFunction}\nconst buffer = new Serialize.SerialBuffer({\n    textEncoder,\n    textDecoder\n})\nlet data = %s\nglobal.transactionType.serialize(buffer, data)\nreturn buffer.asUint8Array()\n})()", transactionJSON);
        V8Array obj = this.gRuntime.executeArrayScript(script);
        return this.v8ArrayToByteArray(obj);
    }

    public Action identityToAction(Identity identity) {
        Action action = new Action();
        action.setAccount(new AccountName(""));
        action.setName(new ActionName("identity"));
        PermissionLevel permissionLevel = identity.getPermissionLevel();
        if (permissionLevel == null || permissionLevel.getAccountName() == null || Strings.isNullOrEmpty((String)permissionLevel.getAccountName().getName()) || permissionLevel.getPermissionName() == null || Strings.isNullOrEmpty((String)permissionLevel.getPermissionName().getName())) {
            action.addAuthorization(SigningRequest.PLACEHOLDER_PERMISSION_LEVEL);
            action.setData(new ActionData("0101000000000000000200000000000000"));
        } else {
            String script = String.format("(function() {\nlet identity = {permission:{actor:'%s',permission:'%s'}}\nconst textEncoder = {encode: global.encodeFunction}\nconst textDecoder = {decode: global.decodeFunction}\nconst buffer = new Serialize.SerialBuffer({\n    textEncoder,\n    textDecoder\n})\nglobal.idType.serialize(buffer, identity)\nreturn Serialize.arrayToHex(buffer.asUint8Array())})()", permissionLevel.getAccountName().getName(), permissionLevel.getPermissionName().getName());
            String packedData = this.gRuntime.executeStringScript(script);
            action.addAuthorization(identity.getPermissionLevel());
            action.setData(new ActionData(packedData));
        }
        return action;
    }

    public void setTransactionFromContext(Transaction transaction, TransactionContext context) {
        String script = String.format("(function() {\nreturn Serialize.transactionHeader(%s, %d)\n})()", context.toJSON(), context.getExpireSeconds() != null ? context.getExpireSeconds() : 60);
        V8Object result = this.gRuntime.executeObjectScript(script);
        transaction.setExpiration(result.getString("expiration"));
        transaction.setRefBlockNum(Long.valueOf(result.getInteger("ref_block_num")));
        transaction.setRefBlockPrefix(Long.valueOf(result.getInteger("ref_block_prefix")));
    }

    public Action getResolvedAction(Map<String, String> abiMap, PermissionLevel signer, Action raw2) throws ESRException {
        String abi = null;
        if (!raw2.getData().isPacked()) {
            throw new ESRException("Cannot resolve an already resolved action");
        }
        if (!raw2.isIdentity()) {
            abi = abiMap.get(raw2.getAccount().getName());
            if (abi == null) {
                throw new ESRException("Missing ABI definition for " + raw2.getAccount().getName());
            }
        } else {
            abi = "global.abi.data";
        }
        String script = String.format("(function() {\nconst contractAbi = %s\nconst signer = %s\nconst PlaceholderName = '%s'\nconst PlaceholderPermission = '%s'\nconst contract = getContract(contractAbi)\nif (signer) {\n   contract.types.get('name').deserialize = (buffer) => {\n       const name = buffer.getName()\n       if (name === PlaceholderName) {\n          return signer.actor\n       } else if (name === PlaceholderPermission) {\n           return signer.permission\n       } else {\n           return name\n       }\n   }\n}\nconst textEncoder = {encode: global.encodeFunction}\nconst textDecoder = {decode: global.decodeFunction}\nconst action = Serialize.deserializeAction(\n    contract,\n    '%s',\n    '%s',\n    %s,\n    '%s',\n    textEncoder,\n    textDecoder\n)\nif (signer) {\n    action.authorization = action.authorization.map((auth) => {\n        let { actor, permission } = auth\n        if (actor === PlaceholderName) {\n            actor = signer.actor\n        }\n        if (permission === PlaceholderPermission) {\n            permission = signer.permission\n        }\n        if (permission === PlaceholderName) {\n            permission = signer.permission\n        }\n        return { actor, permission }\n    })\n}\nreturn JSON.stringify(action)\n})()", abi, signer != null ? signer.toJSON() : UNDEFINED, "............1", "............2", raw2.getAccount().getName(), raw2.getName().getName(), raw2.getAuthorizationJSON(), raw2.getData().getPackedData());
        String resolvedActionJSON = this.gRuntime.executeStringScript(script);
        return new Action((JsonObject)JsonParser.parseString((String)resolvedActionJSON));
    }

    public byte[] getSignatureData(Signature signature) {
        String script = String.format("(function() {\nconst textEncoder = {encode: global.encodeFunction}\nconst textDecoder = {decode: global.decodeFunction}\nconst buffer = new Serialize.SerialBuffer({\n    textEncoder,\n    textDecoder\n})\nconst type = AbiTypes.get('request_signature')\ntype.serialize(buffer, %s)\nreturn buffer.asUint8Array()\n})()", signature.toJSON());
        return this.v8ArrayToByteArray(this.gRuntime.executeArrayScript(script));
    }

    public byte[] serializeSigningRequest(String requestJSON) {
        String script = String.format("(function() {\nconst textEncoder = {encode: global.encodeFunction}\nconst textDecoder = {decode: global.decodeFunction}\nconst buffer = new Serialize.SerialBuffer({\n    textEncoder,\n    textDecoder\n})\nlet data = %s\nglobal.signingRequestType.serialize(buffer, data)\nreturn buffer.asUint8Array()\n})()", requestJSON);
        V8Array obj = this.gRuntime.executeArrayScript(script);
        return this.v8ArrayToByteArray(obj);
    }

    public String getSignatureDigestAsHex(int protocolVersion, byte[] data) {
        String script = String.format("(function() {\nconst textEncoder = {encode: global.encodeFunction}\nconst textDecoder = {decode: global.decodeFunction}\nconst buffer = new Serialize.SerialBuffer({\n    textEncoder,\n    textDecoder\n})\n// protocol version + utf8 \"request\"\nbuffer.pushArray([%d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74])\nlet data = %s\nbuffer.pushArray(data)\nlet bufferArray = buffer.asUint8Array()\nreturn Serialize.arrayToHex(sha256(bufferArray))\n})()", protocolVersion, this.byteArrayToUnt8ScriptValue(data));
        return this.gRuntime.executeStringScript(script);
    }

    private void injectConsole() {
        JavaCallback log = new JavaCallback(){

            public Object invoke(V8Object v8Object, V8Array v8Array) {
                switch (v8Array.getString(0)) {
                    case "debug": {
                        Log.d((String)ESRV8Runtime.V8_TAG, (String)v8Array.getString(1));
                        break;
                    }
                    case "error": {
                        Log.e((String)ESRV8Runtime.V8_TAG, (String)v8Array.getString(1));
                        break;
                    }
                    default: {
                        Log.i((String)ESRV8Runtime.V8_TAG, (String)v8Array.getString(1));
                    }
                }
                return null;
            }
        };
        this.gRuntime.registerJavaMethod(log, "JavaLogger");
        this.gRuntime.executeVoidScript(this.gResourceReader.readResourceString(R.raw.console));
    }

    private void injectEncoderDecoder() {
        JavaCallback encode = new JavaCallback(){

            public Object invoke(V8Object v8Object, V8Array v8Array) {
                String toEncode = v8Array.getString(0);
                byte[] bytes = toEncode.getBytes(Charsets.UTF_8);
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bytes.length);
                byteBuffer.put(bytes);
                V8ArrayBuffer buffer = new V8ArrayBuffer(ESRV8Runtime.this.gRuntime, byteBuffer);
                return new V8TypedArray(ESRV8Runtime.this.gRuntime, buffer, 11, 0, bytes.length);
            }
        };
        JavaCallback decode = new JavaCallback(){

            public Object invoke(V8Object v8Object, V8Array v8Array) {
                V8Array toDecode = v8Array.getArray(0);
                byte[] toDecodeBytes = toDecode.getBytes(0, toDecode.length());
                return new String(toDecodeBytes, Charsets.US_ASCII);
            }
        };
        this.gRuntime.registerJavaMethod(encode, "encodeFunction");
        this.gRuntime.registerJavaMethod(decode, "decodeFunction");
        this.gRuntime.executeVoidScript(this.gResourceReader.readResourceString(R.raw.encoding));
    }

    private void injectGetContract() {
        this.gRuntime.executeVoidScript(this.gResourceReader.readResourceString(R.raw.getcontract));
    }

    private byte[] v8ArrayToByteArray(V8Array array) {
        return array.getBytes(0, array.length());
    }

    private int[] v8ArrayToIntArray(V8Array array) {
        return array.getIntegers(0, array.length());
    }

    private String byteArrayToUnt8ScriptValue(byte[] from) {
        return String.format("Uint8Array.from(%s)", JSONUtil.stringify(from));
    }
}

