/*
 * Decompiled with CFR 0.152.
 */
package com.greymass.esr.models;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.greymass.esr.ESRException;
import com.greymass.esr.interfaces.IRequest;
import com.greymass.esr.models.Action;
import java.util.ArrayList;
import java.util.List;

public class Actions
implements IRequest {
    public static final String VARIANT_TYPE = "action[]";
    private List<Action> gActions = Lists.newArrayList();

    public Actions(JsonArray actions) throws ESRException {
        for (JsonElement el : actions) {
            if (!(el instanceof JsonObject)) {
                throw new ESRException("action[] should be an array of objects");
            }
            this.gActions.add(new Action((JsonObject)el));
        }
    }

    public Actions(List<Action> actions) {
        this.gActions = actions;
    }

    public Actions() {
    }

    public void addAction(Action action) {
        this.gActions.add(action);
    }

    public List<Action> getActions() {
        return this.gActions;
    }

    @Override
    public List<Action> getRawActions() {
        return this.getActions();
    }

    @Override
    public List<Object> toVariant() {
        ArrayList variant = Lists.newArrayList();
        variant.add(VARIANT_TYPE);
        ArrayList actionMaps = Lists.newArrayList();
        for (Action action : this.getActions()) {
            actionMaps.add(action.toMap());
        }
        variant.add(actionMaps);
        return variant;
    }
}

