/*
 * Decompiled with CFR 0.152.
 */
package com.greymass.esr.models;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.greymass.esr.ESRException;
import com.greymass.esr.interfaces.IRequest;
import com.greymass.esr.models.AccountName;
import com.greymass.esr.models.ActionData;
import com.greymass.esr.models.ActionName;
import com.greymass.esr.models.PermissionLevel;
import com.greymass.esr.util.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Action
implements IRequest {
    public static final String VARIANT_TYPE = "action";
    private final String ACCOUNT = "account";
    private final String NAME = "name";
    private final String AUTHORIZATION = "authorization";
    private final String DATA = "data";
    private AccountName gAccount;
    private ActionName gName;
    private List<PermissionLevel> gAuthorization = Lists.newArrayList();
    private ActionData gData;

    public Action() {
    }

    public Action(JsonObject obj) throws ESRException {
        this.gAccount = new AccountName(obj.get("account").getAsString());
        this.gName = new ActionName(obj.get("name").getAsString());
        this.gAuthorization = this.getPermissionsFromJsonArray(obj.getAsJsonArray("authorization"));
        this.gData = obj.get("data").isJsonObject() ? new ActionData(obj.getAsJsonObject("data")) : new ActionData(obj.get("data").getAsString());
    }

    private List<PermissionLevel> getPermissionsFromJsonArray(JsonArray array) throws ESRException {
        ArrayList permissionLevels = Lists.newArrayList();
        for (JsonElement el : array) {
            if (!(el instanceof JsonObject)) {
                throw new ESRException("Permission was not an object");
            }
            permissionLevels.add(new PermissionLevel((JsonObject)el));
        }
        return permissionLevels;
    }

    public boolean isIdentity() {
        return this.gAccount != null && "".equals(this.gAccount.getName()) && this.gName != null && "identity".equals(this.gName.getName());
    }

    public AccountName getAccount() {
        return this.gAccount;
    }

    public void setAccount(AccountName account) {
        this.gAccount = account;
    }

    public ActionName getName() {
        return this.gName;
    }

    public void setName(ActionName name) {
        this.gName = name;
    }

    public List<PermissionLevel> getAuthorization() {
        return this.gAuthorization;
    }

    public String getAuthorizationJSON() {
        ArrayList toEncode = Lists.newArrayList();
        for (PermissionLevel level : this.gAuthorization) {
            toEncode.add(level.toMap());
        }
        return JSONUtil.stringify(toEncode);
    }

    public void addAuthorization(PermissionLevel authorization) {
        this.gAuthorization.add(authorization);
    }

    public ActionData getData() {
        return this.gData;
    }

    public void setData(ActionData data) {
        this.gData = data;
    }

    public Map<String, Object> toMap() {
        HashMap result = Maps.newHashMap();
        result.put("account", this.gAccount.getName());
        result.put("name", this.gName.getName());
        ArrayList auths = Lists.newArrayList();
        for (PermissionLevel permissionLevel : this.gAuthorization) {
            auths.add(permissionLevel.toMap());
        }
        result.put("authorization", auths);
        result.put("data", this.gData.isPacked() ? this.gData.getPackedData() : this.gData.getData());
        return result;
    }

    @Override
    public List<Action> getRawActions() {
        return Lists.newArrayList((Object[])new Action[]{this});
    }

    @Override
    public List<Object> toVariant() {
        ArrayList variant = Lists.newArrayList();
        variant.add(VARIANT_TYPE);
        variant.add(this.toMap());
        return variant;
    }
}

