/*
 * Decompiled with CFR 0.152.
 */
package com.greyblocks.gatekeeper;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.util.Log;
import com.greyblocks.gatekeeper.R;
import com.greyblocks.gatekeeper.UserAccount;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\tJ\u001f\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u0004\u0018\u00010\tJ\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J \u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u000eJ\u000e\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0001J(\u0010'\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\t2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u001b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/greyblocks/gatekeeper/GateKeeper;", "", "context", "Landroid/content/Context;", "accountType", "", "(Landroid/content/Context;I)V", "accountManager", "Landroid/accounts/AccountManager;", "", "preference", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "enter", "", "user", "password", "authToken", "getAccount", "T", "accountClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "getAuthToken", "getCurrentAccount", "Landroid/accounts/Account;", "getList", "", "name", "itemType", "Ljava/lang/reflect/Type;", "isLoggedIn", "", "logout", "requireLogin", "activity", "Landroid/app/Activity;", "saveAccount", "account", "saveList", "list", "Companion", "gatekeeper_release"})
public class GateKeeper {
    private final AccountManager accountManager;
    private final String accountType;
    private final SharedPreferences preference;
    @NotNull
    public static final String TAG = "GateKeeper";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Account getCurrentAccount() {
        Account[] accounts;
        Account[] accountArray = this.accountManager.getAccountsByType(this.accountType);
        Intrinsics.checkExpressionValueIsNotNull((Object)accountArray, (String)"accountManager.getAccountsByType(accountType)");
        Account[] accountArray2 = accounts = accountArray;
        boolean bl = false;
        Account[] accountArray3 = accountArray2;
        boolean bl2 = false;
        if (!(accountArray3.length == 0)) {
            return accounts[0];
        }
        return null;
    }

    @Nullable
    public final String getAuthToken() {
        String string2;
        Account account;
        Account account2 = account = this.getCurrentAccount();
        if (account2 != null) {
            Account account3 = account2;
            boolean bl = false;
            boolean bl2 = false;
            Account it = account3;
            boolean bl3 = false;
            string2 = this.accountManager.peekAuthToken(this.getCurrentAccount(), "authtoken_type_full_access");
        } else {
            string2 = null;
        }
        return string2;
    }

    public final void enter(@NotNull String user, @Nullable String password, @NotNull String authToken) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        if (this.getCurrentAccount() != null) {
            this.logout();
        }
        this.accountManager.addAccountExplicitly(new Account(user, this.accountType), password, null);
        this.accountManager.setAuthToken(this.getCurrentAccount(), "authtoken_type_full_access", authToken);
    }

    public final void logout() {
        if (this.getCurrentAccount() != null) {
            this.accountManager.invalidateAuthToken(this.accountType, this.getAuthToken());
            if (Build.VERSION.SDK_INT >= 22) {
                this.accountManager.removeAccountExplicitly(this.getCurrentAccount());
            } else {
                this.accountManager.removeAccount(this.getCurrentAccount(), null, null);
            }
            this.preference.edit().clear().apply();
        }
    }

    public final boolean isLoggedIn() {
        return this.getAuthToken() != null;
    }

    public final void requireLogin(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        if (!this.isLoggedIn()) {
            this.accountManager.addAccount(this.accountType, "authtoken_type_full_access", null, null, activity, null, null);
            activity.finishAffinity();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void saveList(String name, List<?> list, Class<?> itemType) {
        Class<?> clazz = itemType;
        if (Intrinsics.areEqual(clazz, String.class)) {
            void $this$toTypedArray$iv;
            List<?> list2 = list;
            if (list2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
            }
            Collection collection = list2;
            String string2 = name;
            SharedPreferences.Editor editor = this.preference.edit();
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            if (objectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray2 = objectArray;
            editor.putStringSet(string2, ArraysKt.toSet((Object[])objectArray2)).apply();
        } else if (Intrinsics.areEqual(clazz, Integer.class)) {
            void $this$toTypedArray$iv;
            String string3;
            Collection collection;
            void $this$mapTo$iv$iv;
            List<?> list3 = list;
            if (list3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Int>");
            }
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int n = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv;
                boolean bl = false;
                string3 = String.valueOf((int)it);
                collection.add(string3);
            }
            List convertedList = (List)destination$iv$iv;
            $this$map$iv = convertedList;
            string3 = name;
            collection = this.preference.edit();
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            if (objectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray3 = objectArray;
            collection.putStringSet(string3, ArraysKt.toSet((Object[])objectArray3)).apply();
        } else if (Intrinsics.areEqual(clazz, Float.class)) {
            void $this$toTypedArray$iv;
            String string4;
            Collection collection;
            void $this$mapTo$iv$iv;
            List<?> list4 = list;
            if (list4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Float>");
            }
            Iterable $this$map$iv = list4;
            boolean $i$f$map = false;
            Iterable thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                float it = ((Number)item$iv$iv).floatValue();
                collection = destination$iv$iv;
                boolean bl = false;
                string4 = String.valueOf(it);
                collection.add(string4);
            }
            List convertedList = (List)destination$iv$iv;
            $this$map$iv = convertedList;
            string4 = name;
            collection = this.preference.edit();
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            if (objectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray4 = objectArray;
            collection.putStringSet(string4, ArraysKt.toSet((Object[])objectArray4)).apply();
        } else if (Intrinsics.areEqual(clazz, Boolean.class)) {
            void $this$toTypedArray$iv;
            String string5;
            Collection collection;
            void $this$mapTo$iv$iv;
            List<?> list5 = list;
            if (list5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Boolean>");
            }
            Iterable $this$map$iv = list5;
            boolean $i$f$map = false;
            Iterable thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                boolean it = (Boolean)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                string5 = String.valueOf(it);
                collection.add(string5);
            }
            List convertedList = (List)destination$iv$iv;
            $this$map$iv = convertedList;
            string5 = name;
            collection = this.preference.edit();
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            if (objectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray5 = objectArray;
            collection.putStringSet(string5, ArraysKt.toSet((Object[])objectArray5)).apply();
        } else if (Intrinsics.areEqual(clazz, Long.class)) {
            void $this$toTypedArray$iv;
            String string6;
            Collection collection;
            void $this$mapTo$iv$iv;
            List<?> list6 = list;
            if (list6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Long>");
            }
            Iterable $this$map$iv = list6;
            boolean $i$f$map = false;
            Iterable thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                long it = ((Number)item$iv$iv).longValue();
                collection = destination$iv$iv;
                boolean bl = false;
                string6 = String.valueOf(it);
                collection.add(string6);
            }
            List convertedList = (List)destination$iv$iv;
            $this$map$iv = convertedList;
            string6 = name;
            collection = this.preference.edit();
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            if (objectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray6 = objectArray;
            collection.putStringSet(string6, ArraysKt.toSet((Object[])objectArray6)).apply();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Object> getList(String name, Type itemType) {
        List list;
        Set stringSet = this.preference.getStringSet(name, null);
        Type type = itemType;
        if (Intrinsics.areEqual((Object)type, String.class)) {
            Set set = stringSet;
            list = set != null ? CollectionsKt.toList((Iterable)set) : null;
        } else if (Intrinsics.areEqual((Object)type, Integer.class)) {
            Set set = stringSet;
            if (set != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void var14_41;
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    boolean bl2 = false;
                    Integer n = Integer.parseInt((String)var14_41);
                    collection.add(n);
                }
                list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            } else {
                list = null;
            }
        } else if (Intrinsics.areEqual((Object)type, Float.class)) {
            Set set = stringSet;
            if (set != null) {
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string3;
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    boolean bl3 = false;
                    Float f = Float.valueOf(Float.parseFloat(string3));
                    collection.add(f);
                }
                list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            } else {
                list = null;
            }
        } else if (Intrinsics.areEqual((Object)type, Long.class)) {
            Set set = stringSet;
            if (set != null) {
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string4;
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    boolean bl4 = false;
                    Long l = Long.parseLong(string4);
                    collection.add(l);
                }
                list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            } else {
                list = null;
            }
        } else if (Intrinsics.areEqual((Object)type, Boolean.class)) {
            Set set = stringSet;
            if (set != null) {
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string5;
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    boolean bl5 = false;
                    Boolean bl6 = Boolean.parseBoolean(string5);
                    collection.add(bl6);
                }
                list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            } else {
                list = null;
            }
        } else {
            list = null;
        }
        return list;
    }

    public final void saveAccount(@NotNull Object account) {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        boolean bl = account.getClass().isAnnotationPresent(UserAccount.class);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Class is not recognized as @UserAccount";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Field[] fieldArray = account.getClass().getDeclaredFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)fieldArray, (String)"account.javaClass.declaredFields");
        Field[] $this$forEach$iv = fieldArray;
        boolean $i$f$forEach = false;
        Field[] fieldArray2 = $this$forEach$iv;
        int n = fieldArray2.length;
        for (int i = 0; i < n; ++i) {
            String name;
            Class<?> type;
            Field element$iv;
            Field it = element$iv = fieldArray2[i];
            boolean bl5 = false;
            Field field = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"it");
            field.setAccessible(true);
            Intrinsics.checkExpressionValueIsNotNull((Object)it.getName(), (String)"it.name");
            Intrinsics.checkExpressionValueIsNotNull(it.getType(), (String)"it.type");
            Object value = it.get(account);
            Class<?> clazz = type;
            if (Intrinsics.areEqual(clazz, String.class)) {
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                this.preference.edit().putString(name, (String)object).apply();
                continue;
            }
            if (Intrinsics.areEqual(clazz, Long.TYPE)) {
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                }
                this.preference.edit().putLong(name, ((Long)object).longValue()).apply();
                continue;
            }
            if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.preference.edit().putInt(name, ((Integer)object).intValue()).apply();
                continue;
            }
            if (Intrinsics.areEqual(clazz, Boolean.TYPE)) {
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                }
                this.preference.edit().putBoolean(name, ((Boolean)object).booleanValue()).apply();
                continue;
            }
            if (Intrinsics.areEqual(clazz, Float.TYPE)) {
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                this.preference.edit().putFloat(name, ((Float)object).floatValue()).apply();
                continue;
            }
            if (Intrinsics.areEqual(clazz, List.class)) {
                Type type2 = it.getGenericType();
                if (type2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                }
                Type itemType = ((ParameterizedType)type2).getActualTypeArguments()[0];
                if (value != null) {
                    Type type3 = itemType;
                    if (type3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
                    }
                    this.saveList(name, (List)value, (Class)type3);
                }
                Log.i((String)TAG, (String)("List item type: " + itemType));
                continue;
            }
            Log.w((String)TAG, (String)("Cannot save value for " + it.getName()));
        }
    }

    public final <T> T getAccount(@NotNull Class<T> accountClass) {
        Intrinsics.checkParameterIsNotNull(accountClass, (String)"accountClass");
        boolean bl = this.isLoggedIn();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "User not logged in";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        bl = accountClass.isAnnotationPresent(UserAccount.class);
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string3 = "Class is not recognized as @UserAccount";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        T instance = accountClass.newInstance();
        Field[] fieldArray = accountClass.getDeclaredFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)fieldArray, (String)"accountClass.declaredFields");
        Field[] $this$forEach$iv = fieldArray;
        boolean $i$f$forEach = false;
        Field[] fieldArray2 = $this$forEach$iv;
        int n = fieldArray2.length;
        for (int i = 0; i < n; ++i) {
            Field element$iv;
            Field it = element$iv = fieldArray2[i];
            boolean bl6 = false;
            Field field = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"it");
            field.setAccessible(true);
            Intrinsics.checkExpressionValueIsNotNull((Object)it.getName(), (String)"it.name");
            Class<?> clazz = it.getType();
            if (Intrinsics.areEqual(clazz, String.class)) {
                String value = this.preference.getString(it.getName(), null);
                it.set(instance, value);
                continue;
            }
            if (Intrinsics.areEqual(clazz, Long.TYPE)) {
                long value = this.preference.getLong(it.getName(), 0L);
                it.set(instance, value);
                continue;
            }
            if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
                int value = this.preference.getInt(it.getName(), 0);
                it.set(instance, value);
                continue;
            }
            if (Intrinsics.areEqual(clazz, Boolean.TYPE)) {
                boolean value = this.preference.getBoolean(it.getName(), false);
                it.set(instance, value);
                continue;
            }
            if (Intrinsics.areEqual(clazz, Float.TYPE)) {
                float value = this.preference.getFloat(it.getName(), 0.0f);
                it.set(instance, Float.valueOf(value));
                continue;
            }
            if (Intrinsics.areEqual(clazz, List.class)) {
                String name;
                Type itemType;
                Type type = it.getGenericType();
                if (type == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                }
                Type type2 = itemType = ((ParameterizedType)type).getActualTypeArguments()[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"itemType");
                it.set(instance, this.getList(name, type2));
                continue;
            }
            Log.w((String)TAG, (String)("Cannot get value for " + it.getName()));
        }
        return instance;
    }

    public GateKeeper(@NotNull Context context, int accountType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        AccountManager accountManager = AccountManager.get((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)accountManager, (String)"AccountManager.get(context)");
        this.accountManager = accountManager;
        String string2 = context.getString(accountType);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(accountType)");
        this.accountType = string2;
        this.preference = context.getSharedPreferences(context.getPackageName(), 0);
    }

    public /* synthetic */ GateKeeper(Context context, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = R.string.account_type;
        }
        this(context, n);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/greyblocks/gatekeeper/GateKeeper$Companion;", "", "()V", "TAG", "", "gatekeeper_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

