/*
 * Decompiled with CFR 0.152.
 */
package com.greyblocks.gatekeeper;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.greyblocks.gatekeeper.R;
import com.greyblocks.gatekeeper.UserAccountConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\u0010\u0015\n\u0002\u0010\u0016\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\tJ\b\u0010\u0018\u001a\u0004\u0018\u00010\tJ\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\tJ\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\tJ\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\tJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\tJ\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\tJ\u0016\u0010$\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\tJ\u000e\u0010%\u001a\u0004\u0018\u00010\u0001\"\u0004\b\u0000\u0010&J\u001c\u0010'\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\t2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\tJ\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u0014J\u000e\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.J7\u0010/\u001a\u00020\u00142*\u00100\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050201\"\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000502\u00a2\u0006\u0002\u00103J'\u00104\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\t2\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t01\"\u00020\t\u00a2\u0006\u0002\u00106J\u001a\u00104\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\t2\n\u00105\u001a\u000207\"\u00020\u001dJ\u001a\u00104\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\t2\n\u00105\u001a\u000208\"\u00020\u0005J\u001a\u00104\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\t2\n\u00105\u001a\u000209\"\u00020\"J7\u0010:\u001a\u00020\u00142*\u00100\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\"0201\"\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\"02\u00a2\u0006\u0002\u00103J7\u0010;\u001a\u00020\u00142*\u00100\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0201\"\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t02\u00a2\u0006\u0002\u00103J\u0019\u0010<\u001a\u00020\u0014\"\u0004\b\u0000\u0010&2\u0006\u0010=\u001a\u0002H&\u00a2\u0006\u0002\u0010>J\u0016\u0010?\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u0005J\u0016\u0010?\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010@\u001a\u00020\tR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006A"}, d2={"Lcom/greyblocks/gatekeeper/GateKeeper;", "", "context", "Landroid/content/Context;", "accountType", "", "(Landroid/content/Context;I)V", "accountManager", "Landroid/accounts/AccountManager;", "", "preference", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "userConverter", "Lcom/greyblocks/gatekeeper/UserAccountConverter;", "getUserConverter", "()Lcom/greyblocks/gatekeeper/UserAccountConverter;", "setUserConverter", "(Lcom/greyblocks/gatekeeper/UserAccountConverter;)V", "enter", "", "user", "password", "authToken", "getAuthToken", "getCurrentAccount", "Landroid/accounts/Account;", "getFloatList", "", "", "key", "getInt", "getIntList", "getLong", "", "getLongList", "getStringList", "getUserAccount", "T", "getUserData", "defaultData", "isLoggedIn", "", "logout", "requireLogin", "activity", "Landroid/app/Activity;", "saveIntData", "keyValue", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)V", "saveList", "values", "(Ljava/lang/String;[Ljava/lang/String;)V", "", "", "", "saveLongData", "saveStringData", "saveUserAccount", "account", "(Ljava/lang/Object;)V", "saveUserData", "value", "gatekeeper_release"})
public class GateKeeper {
    @Nullable
    private UserAccountConverter<?> userConverter;
    private final AccountManager accountManager;
    private final String accountType;
    private final SharedPreferences preference;

    @Nullable
    public final UserAccountConverter<?> getUserConverter() {
        return this.userConverter;
    }

    public final void setUserConverter(@Nullable UserAccountConverter<?> userAccountConverter) {
        this.userConverter = userAccountConverter;
    }

    @Nullable
    public final <T> Object getUserAccount() {
        UserAccountConverter<?> userAccountConverter = this.userConverter;
        return userAccountConverter != null ? userAccountConverter.getUserAccount(this) : null;
    }

    public final <T> void saveUserAccount(T account) {
        block0: {
            UserAccountConverter<?> userAccountConverter = this.userConverter;
            if (userAccountConverter == null) break block0;
            userAccountConverter.saveUserAccount(account, this);
        }
    }

    @Nullable
    public final Account getCurrentAccount() {
        Account[] accounts;
        Account[] accountArray = this.accountManager.getAccountsByType(this.accountType);
        Intrinsics.checkExpressionValueIsNotNull((Object)accountArray, (String)"accountManager.getAccountsByType(accountType)");
        Account[] accountArray2 = accounts = accountArray;
        boolean bl = false;
        Account[] accountArray3 = accountArray2;
        boolean bl2 = false;
        if (!(accountArray3.length == 0)) {
            return accounts[0];
        }
        return null;
    }

    @Nullable
    public final String getAuthToken() {
        String string2;
        Account account;
        Account account2 = account = this.getCurrentAccount();
        if (account2 != null) {
            Account account3 = account2;
            boolean bl = false;
            boolean bl2 = false;
            Account it = account3;
            boolean bl3 = false;
            string2 = this.accountManager.peekAuthToken(this.getCurrentAccount(), "authtoken_type_full_access");
        } else {
            string2 = null;
        }
        return string2;
    }

    public final void enter(@NotNull String user, @Nullable String password, @NotNull String authToken) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        if (this.getCurrentAccount() != null) {
            this.logout();
        }
        this.accountManager.addAccountExplicitly(new Account(user, this.accountType), password, null);
        this.accountManager.setAuthToken(this.getCurrentAccount(), "authtoken_type_full_access", authToken);
    }

    public final void saveStringData(Pair<String, String> ... keyValue) {
        Intrinsics.checkParameterIsNotNull(keyValue, (String)"keyValue");
        SharedPreferences.Editor editor = this.preference.edit();
        Pair<String, String>[] $this$forEach$iv = keyValue;
        boolean $i$f$forEach = false;
        Pair<String, String>[] pairArray = $this$forEach$iv;
        int n = pairArray.length;
        for (int i = 0; i < n; ++i) {
            Pair<String, String> element$iv;
            Pair<String, String> it = element$iv = pairArray[i];
            boolean bl = false;
            editor.putString((String)it.getFirst(), (String)it.getSecond());
        }
        editor.apply();
    }

    public final void saveIntData(Pair<String, Integer> ... keyValue) {
        Intrinsics.checkParameterIsNotNull(keyValue, (String)"keyValue");
        SharedPreferences.Editor editor = this.preference.edit();
        Pair<String, Integer>[] $this$forEach$iv = keyValue;
        boolean $i$f$forEach = false;
        Pair<String, Integer>[] pairArray = $this$forEach$iv;
        int n = pairArray.length;
        for (int i = 0; i < n; ++i) {
            Pair<String, Integer> element$iv;
            Pair<String, Integer> it = element$iv = pairArray[i];
            boolean bl = false;
            editor.putInt((String)it.getFirst(), ((Number)it.getSecond()).intValue());
        }
        editor.apply();
    }

    public final void saveLongData(Pair<String, Long> ... keyValue) {
        Intrinsics.checkParameterIsNotNull(keyValue, (String)"keyValue");
        SharedPreferences.Editor editor = this.preference.edit();
        Pair<String, Long>[] $this$forEach$iv = keyValue;
        boolean $i$f$forEach = false;
        Pair<String, Long>[] pairArray = $this$forEach$iv;
        int n = pairArray.length;
        for (int i = 0; i < n; ++i) {
            Pair<String, Long> element$iv;
            Pair<String, Long> it = element$iv = pairArray[i];
            boolean bl = false;
            editor.putLong((String)it.getFirst(), ((Number)it.getSecond()).longValue());
        }
        editor.apply();
    }

    /*
     * WARNING - void declaration
     */
    public final void saveList(@NotNull String key, int ... values) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        SharedPreferences.Editor editor = this.preference.edit();
        int[] nArray = values;
        String string2 = key;
        SharedPreferences.Editor editor2 = editor;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var9_11 = $this$mapTo$iv$iv;
        int n = ((void)var9_11).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var13_15 = item$iv$iv = var9_11[i];
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = String.valueOf((int)it);
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        editor2.putStringSet(string2, CollectionsKt.toSet((Iterable)collection));
        editor.apply();
    }

    /*
     * WARNING - void declaration
     */
    public final void saveList(@NotNull String key, long ... values) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        SharedPreferences.Editor editor = this.preference.edit();
        long[] lArray = values;
        String string2 = key;
        SharedPreferences.Editor editor2 = editor;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var9_11 = $this$mapTo$iv$iv;
        int n = ((void)var9_11).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_15 = item$iv$iv = var9_11[i];
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = String.valueOf((long)it);
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        editor2.putStringSet(string2, CollectionsKt.toSet((Iterable)collection));
        editor.apply();
    }

    /*
     * WARNING - void declaration
     */
    public final void saveList(@NotNull String key, float ... values) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        SharedPreferences.Editor editor = this.preference.edit();
        float[] fArray = values;
        String string2 = key;
        SharedPreferences.Editor editor2 = editor;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var9_11 = $this$mapTo$iv$iv;
        int n = ((void)var9_11).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var13_15 = item$iv$iv = var9_11[i];
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = String.valueOf((float)it);
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        editor2.putStringSet(string2, CollectionsKt.toSet((Iterable)collection));
        editor.apply();
    }

    public final void saveList(@NotNull String key, String ... values) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        SharedPreferences.Editor editor = this.preference.edit();
        editor.putStringSet(key, ArraysKt.toSet((Object[])values));
        editor.apply();
    }

    public final void saveUserData(@NotNull String key, int value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.preference.edit().putInt(key, value).apply();
    }

    public final void saveUserData(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.preference.edit().putString(key, value).apply();
    }

    @Nullable
    public final String getUserData(@NotNull String key, @Nullable String defaultData) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.preference.getString(key, defaultData);
    }

    public static /* synthetic */ String getUserData$default(GateKeeper gateKeeper, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUserData");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return gateKeeper.getUserData(string, string2);
    }

    public final long getLong(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.preference.getLong(key, 0L);
    }

    public final int getInt(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.preference.getInt(key, 0);
    }

    @Nullable
    public final List<String> getStringList(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Set set = this.preference.getStringSet(key, null);
        return set != null ? CollectionsKt.toList((Iterable)set) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<Integer> getIntList(@NotNull String key) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Set set = this.preference.getStringSet(key, null);
        if (set != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void var11_11;
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                boolean bl2 = false;
                Integer n = Integer.parseInt((String)var11_11);
                collection.add(n);
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<Long> getLongList(@NotNull String key) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Set set = this.preference.getStringSet(key, null);
        if (set != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void var11_11;
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                boolean bl2 = false;
                Long l = Long.parseLong((String)var11_11);
                collection.add(l);
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<Float> getFloatList(@NotNull String key) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Set set = this.preference.getStringSet(key, null);
        if (set != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void var11_11;
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                boolean bl2 = false;
                Float f = Float.valueOf(Float.parseFloat((String)var11_11));
                collection.add(f);
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        } else {
            list = null;
        }
        return list;
    }

    public final void logout() {
        if (this.getCurrentAccount() != null) {
            this.accountManager.invalidateAuthToken(this.accountType, this.getAuthToken());
            if (Build.VERSION.SDK_INT >= 22) {
                this.accountManager.removeAccountExplicitly(this.getCurrentAccount());
            } else {
                this.accountManager.removeAccount(this.getCurrentAccount(), null, null);
            }
            this.preference.edit().clear().apply();
        }
    }

    public final boolean isLoggedIn() {
        return this.getAuthToken() != null;
    }

    public final void requireLogin(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        if (!this.isLoggedIn()) {
            this.accountManager.addAccount(this.accountType, "authtoken_type_full_access", null, null, activity, null, null);
            activity.finishAffinity();
        }
    }

    public GateKeeper(@NotNull Context context, int accountType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        AccountManager accountManager = AccountManager.get((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)accountManager, (String)"AccountManager.get(context)");
        this.accountManager = accountManager;
        String string2 = context.getString(accountType);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(accountType)");
        this.accountType = string2;
        this.preference = context.getSharedPreferences("gatekeeper", 0);
    }

    public /* synthetic */ GateKeeper(Context context, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = R.string.account_type;
        }
        this(context, n);
    }
}

