/*
 * Decompiled with CFR 0.152.
 */
package com.greyblocks.gatekeeper;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import com.greyblocks.gatekeeper.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ,\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0013\u001a\u0004\u0018\u00010\bJ\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\bJ\u001c\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\nJ\u0016\u0010 \u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0017J\u0016\u0010 \u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u001aJ\u0016\u0010 \u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010!\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/greyblocks/gatekeeper/GateKeeper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "accountManager", "Landroid/accounts/AccountManager;", "accountType", "", "checkUserAuth", "", "activity", "Landroid/app/Activity;", "enter", "user", "password", "authToken", "userData", "Landroid/os/Bundle;", "getAuthToken", "getCurrentAccount", "Landroid/accounts/Account;", "getInt", "", "key", "getLong", "", "getUserData", "defaultData", "isLoggedIn", "", "logout", "saveUserData", "value", "gatekeeper_release"})
public class GateKeeper {
    private final AccountManager accountManager;
    private final String accountType;

    @Nullable
    public final Account getCurrentAccount() {
        Account[] accountArray;
        Account[] accounts = this.accountManager.getAccountsByType(this.accountType);
        Intrinsics.checkExpressionValueIsNotNull((Object)accounts, (String)"accounts");
        Account[] accountArray2 = accountArray = accounts;
        if (!(accountArray2.length == 0)) {
            return accounts[0];
        }
        return null;
    }

    @Nullable
    public final String getAuthToken() {
        String string;
        Account account;
        Account account2 = account = this.getCurrentAccount();
        if (account2 != null) {
            Account account3;
            Account it = account3 = account2;
            boolean bl = false;
            string = this.accountManager.peekAuthToken(this.getCurrentAccount(), "authtoken_type_full_access");
        } else {
            string = null;
        }
        return string;
    }

    public final void enter(@NotNull String user, @Nullable String password, @NotNull String authToken, @Nullable Bundle userData) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        if (this.getCurrentAccount() != null) {
            this.logout();
        }
        this.accountManager.addAccountExplicitly(new Account(user, this.accountType), password, userData);
        this.accountManager.setAuthToken(this.getCurrentAccount(), "authtoken_type_full_access", authToken);
    }

    public static /* synthetic */ void enter$default(GateKeeper gateKeeper, String string, String string2, String string3, Bundle bundle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: enter");
        }
        if ((n & 8) != 0) {
            bundle = null;
        }
        gateKeeper.enter(string, string2, string3, bundle);
    }

    public final void saveUserData(@NotNull String key, long value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.accountManager.setUserData(this.getCurrentAccount(), key, String.valueOf(value));
    }

    public final void saveUserData(@NotNull String key, int value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.accountManager.setUserData(this.getCurrentAccount(), key, String.valueOf(value));
    }

    public final void saveUserData(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.accountManager.setUserData(this.getCurrentAccount(), key, value);
    }

    @Nullable
    public final String getUserData(@NotNull String key, @Nullable String defaultData) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = this.accountManager.getUserData(this.getCurrentAccount(), key);
        if (string == null) {
            string = defaultData;
        }
        return string;
    }

    @Nullable
    public static /* synthetic */ String getUserData$default(GateKeeper gateKeeper, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUserData");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return gateKeeper.getUserData(string, string2);
    }

    public final long getLong(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Object object = this.accountManager.getUserData(this.getCurrentAccount(), key);
        return object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 0L;
    }

    public final int getInt(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Object object = this.accountManager.getUserData(this.getCurrentAccount(), key);
        return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
    }

    public final void logout() {
        if (this.getCurrentAccount() != null) {
            this.accountManager.invalidateAuthToken(this.accountType, this.getAuthToken());
            if (Build.VERSION.SDK_INT >= 22) {
                this.accountManager.removeAccountExplicitly(this.getCurrentAccount());
            } else {
                this.accountManager.removeAccount(this.getCurrentAccount(), null, null);
            }
        }
    }

    public final boolean isLoggedIn() {
        return this.getAuthToken() != null;
    }

    public final void checkUserAuth(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        if (!this.isLoggedIn()) {
            this.accountManager.addAccount(this.accountType, "authtoken_type_full_access", null, null, activity, null, null);
            activity.finish();
        }
    }

    public GateKeeper(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        AccountManager accountManager = AccountManager.get((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)accountManager, (String)"AccountManager.get(context)");
        this.accountManager = accountManager;
        String string2 = context.getString(R.string.account_type);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.string.account_type)");
        this.accountType = string2;
    }
}

