/*
 * Decompiled with CFR 0.152.
 */
package com.greyblocks.gatekeeper;

import android.accounts.AbstractAccountAuthenticator;
import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.accounts.NetworkErrorException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.greyblocks.gatekeeper.Gate;

public class AccountAuthenticator
extends AbstractAccountAuthenticator {
    public static final String ARG_ACCOUNT_NAME = "arg_account_name";
    public static final String ARG_ACCOUNT_TYPE = "arg_account_type";
    public static final String ARG_AUTH_TYPE = "arg_auth_type";
    public static final String ARG_IS_ADDING_NEW_ACCOUNT = "is_adding_new_account";
    public static final String AUTHTOKEN_TYPE_READ_ONLY = "authtoken_type_read_only";
    public static final String AUTHTOKEN_TYPE_FULL_ACCESS = "authtoken_type_full_access";
    private Context context;
    private Class<?> loginActivityClass;

    public AccountAuthenticator(Context context) {
        super(context);
        this.loginActivityClass = ((Gate)context).getGateClass();
        this.context = context;
    }

    public Bundle editProperties(AccountAuthenticatorResponse response, String accountType) {
        return null;
    }

    public Bundle addAccount(AccountAuthenticatorResponse response, String accountType, String authTokenType, String[] requiredFeatures, Bundle options) throws NetworkErrorException {
        Intent intent = new Intent(this.context, this.loginActivityClass);
        intent.addFlags(0x4000000);
        intent.putExtra(ARG_ACCOUNT_TYPE, accountType);
        intent.putExtra(ARG_AUTH_TYPE, authTokenType);
        intent.putExtra(ARG_IS_ADDING_NEW_ACCOUNT, true);
        intent.putExtra("accountAuthenticatorResponse", (Parcelable)response);
        Bundle bundle = new Bundle();
        bundle.putParcelable("intent", (Parcelable)intent);
        return bundle;
    }

    public Bundle confirmCredentials(AccountAuthenticatorResponse response, Account account, Bundle options) throws NetworkErrorException {
        return null;
    }

    public Bundle getAuthToken(AccountAuthenticatorResponse response, Account account, String authTokenType, Bundle options) throws NetworkErrorException {
        String password;
        if (!authTokenType.equals(AUTHTOKEN_TYPE_READ_ONLY) && !authTokenType.equals(AUTHTOKEN_TYPE_FULL_ACCESS)) {
            Bundle result = new Bundle();
            result.putString("errorMessage", "invalid authTokenType");
            return result;
        }
        AccountManager am = AccountManager.get((Context)this.context);
        String authToken = am.peekAuthToken(account, authTokenType);
        if (!TextUtils.isEmpty((CharSequence)authToken) || (password = am.getPassword(account)) != null) {
            // empty if block
        }
        if (!TextUtils.isEmpty((CharSequence)authToken)) {
            Bundle result = new Bundle();
            result.putString("authAccount", account.name);
            result.putString("accountType", account.type);
            result.putString("authtoken", authToken);
            return result;
        }
        Intent intent = new Intent(this.context, this.loginActivityClass);
        intent.addFlags(0x4000000);
        intent.putExtra("accountAuthenticatorResponse", (Parcelable)response);
        intent.putExtra(ARG_ACCOUNT_TYPE, account.type);
        intent.putExtra(ARG_AUTH_TYPE, authTokenType);
        intent.putExtra(ARG_ACCOUNT_NAME, account.name);
        Bundle bundle = new Bundle();
        bundle.putParcelable("intent", (Parcelable)intent);
        return bundle;
    }

    public String getAuthTokenLabel(String authTokenType) {
        return null;
    }

    public Bundle updateCredentials(AccountAuthenticatorResponse response, Account account, String authTokenType, Bundle options) throws NetworkErrorException {
        return null;
    }

    public Bundle hasFeatures(AccountAuthenticatorResponse response, Account account, String[] features) throws NetworkErrorException {
        return new Bundle();
    }
}

