/*
 * Decompiled with CFR 0.152.
 */
package com.greyblocks.gatekeeper;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J,\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u00072\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0006\u0010\u001c\u001a\u00020\fJ\u0016\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/greyblocks/gatekeeper/GateKeeper;", "", "accountManager", "Landroid/accounts/AccountManager;", "sharedPreferences", "Landroid/content/SharedPreferences;", "accountType", "", "handler", "Landroid/os/Handler;", "(Landroid/accounts/AccountManager;Landroid/content/SharedPreferences;Ljava/lang/String;Landroid/os/Handler;)V", "checkUserAuth", "", "activity", "Landroid/app/Activity;", "getAuthToken", "getCurrentAccount", "Landroid/accounts/Account;", "getUserData", "key", "isLoggedIn", "", "login", "account", "password", "authToken", "userData", "Landroid/os/Bundle;", "logout", "saveUserData", "value", "gatekeeper_release"})
public class GateKeeper {
    private final AccountManager accountManager;
    private final SharedPreferences sharedPreferences;
    private final String accountType;
    private final Handler handler;

    @Nullable
    public final Account getCurrentAccount() {
        Account[] accountArray;
        Account[] accountArray2;
        Account[] accounts = this.accountManager.getAccountsByType(this.accountType);
        if (accounts != null && !((accountArray2 = (accountArray = accounts)).length == 0)) {
            return accounts[0];
        }
        return null;
    }

    @Nullable
    public final String getAuthToken() {
        String string;
        Account account;
        Account account2 = account = this.getCurrentAccount();
        if (account2 != null) {
            Account account3;
            Account it = account3 = account2;
            string = this.accountManager.peekAuthToken(this.getCurrentAccount(), "authtoken_type_full_access");
        } else {
            string = null;
        }
        return string;
    }

    public final void login(@NotNull Account account, @Nullable String password, @NotNull String authToken, @Nullable Bundle userData) {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        if (this.getCurrentAccount() != null) {
            this.logout();
        }
        this.accountManager.addAccountExplicitly(account, password, userData);
        this.accountManager.setAuthToken(this.getCurrentAccount(), "authtoken_type_full_access", authToken);
    }

    public static /* bridge */ /* synthetic */ void login$default(GateKeeper gateKeeper, Account account, String string, String string2, Bundle bundle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: login");
        }
        if ((n & 8) != 0) {
            bundle = null;
        }
        gateKeeper.login(account, string, string2, bundle);
    }

    public final void saveUserData(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.accountManager.setUserData(this.getCurrentAccount(), key, value);
    }

    @Nullable
    public final String getUserData(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.accountManager.getUserData(this.getCurrentAccount(), key);
    }

    public final void logout() {
        if (this.getCurrentAccount() != null) {
            this.accountManager.invalidateAuthToken(this.accountType, this.getAuthToken());
            if (Build.VERSION.SDK_INT >= 22) {
                this.accountManager.removeAccountExplicitly(this.getCurrentAccount());
            } else {
                this.accountManager.removeAccount(this.getCurrentAccount(), null, null);
            }
        }
    }

    public final boolean isLoggedIn() {
        return this.getAuthToken() != null;
    }

    public final void checkUserAuth(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        if (!this.isLoggedIn()) {
            this.accountManager.addAccount(this.accountType, "authtoken_type_full_access", null, null, activity, null, null);
            activity.finish();
        }
    }

    public GateKeeper(@NotNull AccountManager accountManager, @NotNull SharedPreferences sharedPreferences, @NotNull String accountType, @NotNull Handler handler) {
        Intrinsics.checkParameterIsNotNull((Object)accountManager, (String)"accountManager");
        Intrinsics.checkParameterIsNotNull((Object)sharedPreferences, (String)"sharedPreferences");
        Intrinsics.checkParameterIsNotNull((Object)accountType, (String)"accountType");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        this.accountManager = accountManager;
        this.sharedPreferences = sharedPreferences;
        this.accountType = accountType;
        this.handler = handler;
    }
}

