/*
 * Decompiled with CFR 0.152.
 */
package com.greenpay.sdk.cipher.aesctr.utils;

import android.util.Base64;
import com.greenpay.sdk.cipher.aesctr.models.AESCounter;
import com.greenpay.sdk.cipher.aesctr.models.AESKey;
import com.greenpay.sdk.cipher.exceptions.GException;
import com.greenpay.sdk.cipher.utils.Logger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESCRTUtils {
    private static final String TAG = AESCRTUtils.class.getSimpleName();

    public static AESKey generateAESKey() {
        int[] key = new int[16];
        Random random = new Random();
        for (int i = 0; i < 16; ++i) {
            int randomNumber;
            key[i] = randomNumber = random.nextInt(256);
        }
        AESKey aesKey = new AESKey(key);
        return aesKey;
    }

    public static AESCounter generateAESCounter() {
        AESCounter aesCounter = new AESCounter(new Random().nextInt(256));
        return aesCounter;
    }

    public static byte[] cipherWithAESCTR(byte[] plainTextAsByteArray, byte[] key, byte[] counter) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        SecretKeySpec originalKey = new SecretKeySpec(key, 0, key.length, "AES");
        cipher.init(1, (Key)originalKey, new IvParameterSpec(counter));
        byte[] cipheredValue = cipher.doFinal(plainTextAsByteArray);
        return cipheredValue;
    }

    public static String cipherWithPublicKey(String textToCipher, String publicKeyContent) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, GException {
        PublicKey rsaPublicKey = AESCRTUtils.stringToPublicKey(publicKeyContent);
        if (rsaPublicKey == null) {
            throw new GException("Invalid public key format.");
        }
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, rsaPublicKey);
        byte[] encryptedBytes = cipher.doFinal(textToCipher.getBytes());
        return Base64.encodeToString((byte[])encryptedBytes, (int)2);
    }

    public static PublicKey stringToPublicKey(String publicKeyString) {
        try {
            if (publicKeyString.contains("-----BEGIN PUBLIC KEY-----") || publicKeyString.contains("-----END PUBLIC KEY-----")) {
                publicKeyString = publicKeyString.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
            }
            byte[] keyBytes = Base64.decode((String)publicKeyString, (int)0);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            Logger.e(TAG, e.getMessage());
            return null;
        }
    }
}

