/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.utils;

import com.greatmancode.com.zaxxer.libs.hikari.HikariConfig;
import com.greatmancode.com.zaxxer.libs.hikari.HikariDataSource;
import com.greatmancode.craftconomy3.Cause;
import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.LogInfo;
import com.greatmancode.craftconomy3.account.Account;
import com.greatmancode.craftconomy3.currency.Currency;
import com.greatmancode.craftconomy3.storage.StorageEngine;
import com.greatmancode.craftconomy3.storage.sql.H2Engine;
import com.greatmancode.craftconomy3.storage.sql.MySQLEngine;
import com.greatmancode.craftconomy3.storage.sql.SQLStorageEngine;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class OldFormatConverter {
    private HikariDataSource db;
    private String tablePrefix;

    public void run() throws SQLException, IOException, ParseException {
        JSONObject entry;
        String dbType = Common.getInstance().getMainConfig().getString("System.Database.Type");
        HikariConfig config = new HikariConfig();
        if (dbType.equalsIgnoreCase("mysql")) {
            config.setMaximumPoolSize(10);
            config.setDataSourceClassName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
            config.addDataSourceProperty("serverName", Common.getInstance().getMainConfig().getString("System.Database.Address"));
            config.addDataSourceProperty("port", Common.getInstance().getMainConfig().getString("System.Database.Port"));
            config.addDataSourceProperty("databaseName", Common.getInstance().getMainConfig().getString("System.Database.Db"));
            config.addDataSourceProperty("user", Common.getInstance().getMainConfig().getString("System.Database.Username"));
            config.addDataSourceProperty("password", Common.getInstance().getMainConfig().getString("System.Database.Password"));
            config.addDataSourceProperty("autoDeserialize", true);
            config.setConnectionTimeout(5000L);
            this.db = new HikariDataSource(config);
        } else if (dbType.equalsIgnoreCase("sqlite")) {
            config.setDriverClassName("org.sqlite.JDBC");
            config.setJdbcUrl("jdbc:sqlite:" + Common.getInstance().getServerCaller().getDataFolder() + File.separator + "database.db");
            this.db = new HikariDataSource(config);
        } else {
            Common.getInstance().sendConsoleMessage(Level.SEVERE, "Unknown database type for old format converter!");
            return;
        }
        Connection connection = this.db.getConnection();
        this.tablePrefix = Common.getInstance().getMainConfig().getString("System.Database.Prefix");
        File accountFile = new File(Common.getInstance().getServerCaller().getDataFolder(), "accounts.json");
        Common.getInstance().sendConsoleMessage(Level.INFO, "Doing a backup in a xml file before doing the conversion.");
        JSONObject mainObject = new JSONObject();
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving currency table");
        PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "currency");
        ResultSet set = statement.executeQuery();
        JSONArray array = new JSONArray();
        while (set.next()) {
            entry = new JSONObject();
            entry.put("id", set.getInt("id"));
            entry.put("name", set.getString("name"));
            entry.put("plural", set.getString("plural"));
            entry.put("minor", set.getString("minor"));
            entry.put("minorPlural", set.getString("minorPlural"));
            entry.put("sign", set.getString("sign"));
            entry.put("status", set.getBoolean("status"));
            array.add(entry);
        }
        statement.close();
        mainObject.put("currencies", array);
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving world group table");
        array = new JSONArray();
        statement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "worldgroup");
        set = statement.executeQuery();
        while (set.next()) {
            entry = new JSONObject();
            entry.put("groupName", set.getString("groupName"));
            entry.put("worldList", set.getString("worldList"));
            array.add(entry);
        }
        statement.close();
        mainObject.put("worldgroups", array);
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving exchange table");
        array = new JSONArray();
        statement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "exchange");
        set = statement.executeQuery();
        while (set.next()) {
            entry = new JSONObject();
            entry.put("from_currency_id", set.getInt("from_currency_id"));
            entry.put("to_currency_id", set.getInt("to_currency_id"));
            entry.put("amount", set.getDouble("amount"));
            array.add(entry);
        }
        statement.close();
        mainObject.put("exchanges", array);
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving config table");
        array = new JSONArray();
        statement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "config");
        set = statement.executeQuery();
        while (set.next()) {
            entry = new JSONObject();
            entry.put("name", set.getString("name"));
            entry.put("value", set.getString("value"));
            array.add(entry);
        }
        statement.close();
        mainObject.put("configs", array);
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving account table");
        array = new JSONArray();
        statement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "account");
        set = statement.executeQuery();
        while (set.next()) {
            entry = new JSONObject();
            entry.put("name", set.getString("name"));
            entry.put("infiniteMoney", set.getBoolean("infiniteMoney"));
            entry.put("ignoreACL", set.getBoolean("ignoreACL"));
            entry.put("uuid", set.getString("uuid"));
            JSONArray balanceArray = new JSONArray();
            PreparedStatement internalStatement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "balance WHERE username_id=?");
            internalStatement.setInt(1, set.getInt("id"));
            ResultSet internalSet = internalStatement.executeQuery();
            while (internalSet.next()) {
                JSONObject object = new JSONObject();
                object.put("currency_id", internalSet.getInt("currency_id"));
                object.put("worldName", internalSet.getString("worldName"));
                object.put("balance", internalSet.getDouble("balance"));
                balanceArray.add(object);
            }
            internalStatement.close();
            entry.put("balances", balanceArray);
            internalStatement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "log WHERE username_id=?");
            internalStatement.setInt(1, set.getInt("id"));
            internalSet = internalStatement.executeQuery();
            JSONArray logArray = new JSONArray();
            while (internalSet.next()) {
                JSONObject object = new JSONObject();
                object.put("type", this.getObject(internalSet.getBlob("type")).toString());
                object.put("cause", this.getObject(internalSet.getBlob("cause")).toString());
                object.put("timestamp", internalSet.getTimestamp("timestamp").getTime());
                object.put("causeReason", internalSet.getString("causeReason"));
                object.put("currencyName", internalSet.getString("currencyName"));
                object.put("worldName", internalSet.getString("worldName"));
                object.put("amount", internalSet.getDouble("amount"));
                logArray.add(object);
            }
            internalStatement.close();
            entry.put("logs", logArray);
            internalStatement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "acl WHERE account_id=?");
            internalStatement.setInt(1, set.getInt("id"));
            internalSet = internalStatement.executeQuery();
            JSONArray aclArray = new JSONArray();
            while (internalSet.next()) {
                JSONObject object = new JSONObject();
                object.put("playerName", internalSet.getString("playerName"));
                object.put("deposit", internalSet.getBoolean("deposit"));
                object.put("withdraw", internalSet.getBoolean("withdraw"));
                object.put("acl", internalSet.getBoolean("acl"));
                object.put("balance", internalSet.getBoolean("balance"));
                object.put("owner", internalSet.getBoolean("owner"));
                aclArray.add(object);
            }
            internalStatement.close();
            entry.put("acls", aclArray);
            array.add(entry);
        }
        statement.close();
        mainObject.put("accounts", array);
        Common.getInstance().sendConsoleMessage(Level.INFO, "Writing json file");
        FileWriter writer = new FileWriter(accountFile);
        writer.write(mainObject.toJSONString());
        writer.flush();
        writer.close();
        Common.getInstance().sendConsoleMessage(Level.INFO, "File written! Dropping all tables");
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "config");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "acl");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "balance");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "log");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "worldgroup");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "exchange");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "account");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "currency");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "payday");
        statement.execute();
        statement.close();
        connection.close();
        this.step2();
    }

    public void step2() throws SQLException, IOException, ParseException {
        Common.getInstance().sendConsoleMessage(Level.INFO, "Converting step 2: Inserting the data back in all the new tables");
        Common.getInstance().sendConsoleMessage(Level.INFO, "Creating the new tables");
        String dbType = Common.getInstance().getMainConfig().getString("System.Database.Type");
        if (dbType.equals("sqlite")) {
            Common.getInstance().sendConsoleMessage(Level.INFO, "You are using SQLite! This is now deprecated. Selecting H2 instead.");
            Common.getInstance().getMainConfig().setValue("System.Database.Type", "h2");
            dbType = "h2";
        }
        SQLStorageEngine engine = null;
        HikariConfig config = new HikariConfig();
        if (dbType.equalsIgnoreCase("mysql")) {
            engine = new MySQLEngine();
        } else if (dbType.equalsIgnoreCase("h2")) {
            engine = new H2Engine();
        } else {
            throw new UnsupportedOperationException("Unknown database!");
        }
        ((StorageEngine)engine).disableAutoCommit();
        Common.getInstance().sendConsoleMessage(Level.INFO, "Loading backup json file");
        File accountFile = new File(Common.getInstance().getServerCaller().getDataFolder(), "accounts.json");
        System.out.println(accountFile.exists());
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(new FileReader(accountFile));
        HashMap<Integer, String> currenciesMap = new HashMap<Integer, String>();
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving currencies");
        JSONArray currencyArray = (JSONArray)jsonObject.get("currencies");
        for (JSONObject obj : currencyArray) {
            currenciesMap.put(((Long)obj.get("id")).intValue(), (String)obj.get("name"));
            Currency currency = new Currency((String)obj.get("name"), (String)obj.get("plural"), (String)obj.get("minor"), (String)obj.get("minorPlural"), (String)obj.get("sign"));
            try {
                Class<?> clazz = currency.getClass();
                Method setDefault = clazz.getDeclaredMethod("setDefault", Boolean.TYPE);
                setDefault.setAccessible(true);
                setDefault.invoke((Object)currency, (boolean)((Boolean)obj.get("status")));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            ((StorageEngine)engine).saveCurrency("", currency);
        }
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving world groups...");
        JSONArray worldgroup = (JSONArray)jsonObject.get("worldgroups");
        for (JSONObject obj : worldgroup) {
            ((StorageEngine)engine).saveWorldGroup((String)obj.get("groupName"), (String)obj.get("worldList"));
        }
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving Exchange rates");
        JSONArray exchangeArray = (JSONArray)jsonObject.get("exchanges");
        for (JSONObject obj : exchangeArray) {
            int id_from = ((Long)obj.get("from_currency_id")).intValue();
            int id_to = ((Long)obj.get("to_currency_id")).intValue();
            ((StorageEngine)engine).setExchangeRate(((StorageEngine)engine).getCurrency((String)currenciesMap.get(id_from)), ((StorageEngine)engine).getCurrency((String)currenciesMap.get(id_to)), (Double)obj.get("amount"));
        }
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving configs");
        JSONArray configArray = (JSONArray)jsonObject.get("configs");
        for (JSONObject obj : configArray) {
            if (obj.get("name").equals("dbVersion")) continue;
            ((StorageEngine)engine).setConfigEntry((String)obj.get("name"), (String)obj.get("value"));
        }
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving accounts. This may take a long time.");
        boolean log = false;
        if (Common.getInstance().getMainConfig().getBoolean("System.Logging.Enabled")) {
            Common.getInstance().getMainConfig().setValue("System.Logging.Enabled", false);
            log = true;
        }
        JSONArray accounts = (JSONArray)jsonObject.get("accounts");
        for (JSONObject obj : accounts) {
            String name = (String)obj.get("name");
            Account account = null;
            account = name.startsWith("bank:") ? ((StorageEngine)engine).getAccount(name.split(":")[1], true, false) : ((StorageEngine)engine).getAccount(name, false, false);
            ((StorageEngine)engine).setIgnoreACL(account, (Boolean)obj.get("ignoreACL"));
            ((StorageEngine)engine).setInfiniteMoney(account, (Boolean)obj.get("infiniteMoney"));
            if (obj.get("uuid") != null) {
                ((StorageEngine)engine).updateUUID(account.getAccountName(), UUID.fromString((String)obj.get("uuid")));
            }
            JSONArray balances = (JSONArray)obj.get("balances");
            for (JSONObject internalObj : balances) {
                Currency currency = ((StorageEngine)engine).getCurrency((String)currenciesMap.get(((Long)internalObj.get("currency_id")).intValue()));
                if (currency == null) continue;
                ((StorageEngine)engine).setBalance(account, (Double)internalObj.get("balance"), currency, (String)internalObj.get("worldName"));
            }
            JSONArray logs = (JSONArray)obj.get("logs");
            for (JSONObject internalObj : logs) {
                ((StorageEngine)engine).saveLog(LogInfo.valueOf((String)internalObj.get("type")), Cause.valueOf((String)internalObj.get("cause")), (String)internalObj.get("causeReason"), account, (Double)internalObj.get("amount"), ((StorageEngine)engine).getCurrency((String)internalObj.get("currencyName")), (String)internalObj.get("worldName"), new Timestamp((Long)internalObj.get("timestamp")));
            }
            JSONArray acls = (JSONArray)obj.get("acls");
            for (JSONObject internalObj : acls) {
                ((StorageEngine)engine).saveACL(account, (String)internalObj.get("playerName"), (Boolean)internalObj.get("deposit"), (Boolean)internalObj.get("withdraw"), (Boolean)internalObj.get("acl"), (Boolean)internalObj.get("balance"), (Boolean)internalObj.get("owner"));
            }
        }
        ((StorageEngine)engine).commit();
        ((StorageEngine)engine).enableAutoCommit();
        if (log) {
            Common.getInstance().getMainConfig().setValue("System.Logging.Enabled", true);
        }
        Common.getInstance().sendConsoleMessage(Level.INFO, "Converting done!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getObject(Blob blob) throws SQLException {
        try {
            ObjectInputStream is = null;
            is = new ObjectInputStream(blob.getBinaryStream());
            Object o = null;
            try {
                Object object = is.readObject();
                return object;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception ignored) {}
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return null;
    }
}

