/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.language;

import com.greatmancode.craftconomy3.tools.configuration.Config;
import com.greatmancode.craftconomy3.tools.configuration.ConfigurationManager;
import com.greatmancode.craftconomy3.tools.interfaces.caller.ServerCaller;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class LanguageManager {
    private Config languageFile = null;
    private Map<String, String> languageList = new HashMap<String, String>();
    private ServerCaller serverCaller;
    private File path;
    private String fileName;

    public LanguageManager(ServerCaller serverCaller, File path, String fileName) {
        this.languageFile = new ConfigurationManager(serverCaller).loadFile(path, fileName);
        this.serverCaller = serverCaller;
        this.path = path;
        this.fileName = fileName;
        this.loadLanguage();
    }

    private void loadLanguage() {
        try {
            this.languageList = this.languageFile.getStringMap("");
        }
        catch (ClassCastException e) {
            new File(this.path, this.fileName).delete();
            this.languageFile = new ConfigurationManager(this.serverCaller).loadFile(this.path, this.fileName);
            this.languageList = this.languageFile.getStringMap("");
        }
    }

    public void addLanguageEntry(String key, String value) {
        if (!this.languageList.containsKey(key)) {
            this.languageFile.setValue(key, value);
            this.loadLanguage();
        }
    }

    public String parse(String key, Object ... args) {
        return String.format(this.languageList.get(key), args);
    }

    public String getString(String key) {
        return this.languageList.get(key);
    }
}

