/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.configuration.bukkit;

import com.greatmancode.craftconomy3.tools.configuration.Config;
import com.greatmancode.craftconomy3.tools.interfaces.caller.ServerCaller;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class BukkitConfig
extends Config {
    private final YamlConfiguration configFile;

    public BukkitConfig(InputStream is, ServerCaller serverCaller) {
        super(is, serverCaller);
        this.configFile = YamlConfiguration.loadConfiguration((InputStream)is);
    }

    public BukkitConfig(File folder, String fileName, ServerCaller serverCaller) {
        super(folder, fileName, serverCaller);
        this.configFile = YamlConfiguration.loadConfiguration((File)this.file);
    }

    @Override
    public int getInt(String path) {
        return this.configFile.getInt(path);
    }

    @Override
    public long getLong(String path) {
        return this.configFile.getLong(path);
    }

    @Override
    public double getDouble(String path) {
        return this.configFile.getDouble(path);
    }

    @Override
    public String getString(String path) {
        return this.configFile.getString(path);
    }

    @Override
    public boolean getBoolean(String path) {
        return this.configFile.getBoolean(path);
    }

    @Override
    public void setValue(String path, Object value) {
        this.configFile.set(path, value);
        try {
            this.configFile.save(this.file);
        }
        catch (IOException e) {
            this.serverCaller.getLogger().severe("Error while saving + " + this.file.getName() + ". Error: " + e.getMessage());
        }
    }

    @Override
    public boolean has(String path) {
        return this.configFile.contains(path);
    }

    @Override
    public Map<String, String> getStringMap(String path) {
        HashMap<String, String> values = new HashMap<String, String>();
        ConfigurationSection configurationSection = this.configFile.getConfigurationSection(path);
        if (configurationSection != null) {
            for (Map.Entry entry : configurationSection.getValues(false).entrySet()) {
                values.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return values;
    }

    @Override
    public List<String> getStringList(String path) {
        return this.configFile.getStringList(path);
    }
}

