/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.caller.canary;

import com.greatmancode.craftconomy3.tools.interfaces.caller.PlayerCaller;
import com.greatmancode.craftconomy3.tools.interfaces.caller.ServerCaller;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.canarymod.Canary;

public class CanaryPlayerCaller
extends PlayerCaller {
    public CanaryPlayerCaller(ServerCaller caller) {
        super(caller);
    }

    @Override
    public boolean checkPermission(String playerName, String perm) {
        if (playerName.equals("Console")) {
            return true;
        }
        return Canary.getServer().getPlayer(playerName).hasPermission(perm) || this.isOp(playerName);
    }

    @Override
    public void sendMessage(String playerName, String message) {
        if (playerName.equals("Console")) {
            Canary.getServer().message(this.getCaller().addColor(this.getCaller().getCommandPrefix() + message));
        } else {
            Canary.getServer().getPlayer(playerName).message(this.getCaller().addColor(this.getCaller().getCommandPrefix() + message));
        }
    }

    @Override
    public String getPlayerWorld(String playerName) {
        return Canary.getServer().getPlayer(playerName).getWorld().getName();
    }

    @Override
    public String getPlayerWorld(UUID uuid) {
        return Canary.getServer().getPlayerFromUUID(uuid).getWorld().getName();
    }

    @Override
    public boolean isOnline(String playerName) {
        return Canary.getServer().getPlayer(playerName) != null;
    }

    @Override
    public List<String> getOnlinePlayers() {
        return Arrays.asList(Canary.getServer().getPlayerNameList());
    }

    @Override
    public boolean isOp(String playerName) {
        return Canary.ops().isOpped(playerName);
    }

    @Override
    public UUID getUUID(String playerName) {
        return null;
    }
}

