/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.caller.bukkit;

import com.greatmancode.craftconomy3.tools.interfaces.BukkitLoader;
import com.greatmancode.craftconomy3.tools.interfaces.caller.PlayerCaller;
import com.greatmancode.craftconomy3.tools.interfaces.caller.ServerCaller;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class BukkitPlayerCaller
extends PlayerCaller {
    public BukkitPlayerCaller(ServerCaller caller) {
        super(caller);
    }

    @Override
    public boolean checkPermission(String playerName, String perm) {
        Player p = ((BukkitLoader)this.getCaller().getLoader()).getServer().getPlayerExact(playerName);
        boolean result = p != null ? p.isOp() || p.hasPermission(perm) : true;
        return result;
    }

    @Override
    public void sendMessage(String playerName, String message) {
        Player p = ((BukkitLoader)this.getCaller().getLoader()).getServer().getPlayerExact(playerName);
        if (p != null) {
            p.sendMessage(this.getCaller().addColor(this.getCaller().getCommandPrefix() + message));
        } else {
            ((BukkitLoader)this.getCaller().getLoader()).getServer().getConsoleSender().sendMessage(this.getCaller().addColor(this.getCaller().getCommandPrefix() + message));
        }
    }

    @Override
    public String getPlayerWorld(String playerName) {
        Player p = ((BukkitLoader)this.getCaller().getLoader()).getServer().getPlayerExact(playerName);
        return p != null ? p.getWorld().getName() : "";
    }

    @Override
    public String getPlayerWorld(UUID uuid) {
        Player p = ((BukkitLoader)this.getCaller().getLoader()).getServer().getPlayer(uuid);
        return p != null ? p.getWorld().getName() : "";
    }

    @Override
    public boolean isOnline(String playerName) {
        return ((BukkitLoader)this.getCaller().getLoader()).getServer().getPlayerExact(playerName) != null;
    }

    @Override
    public List<String> getOnlinePlayers() {
        ArrayList<String> list = new ArrayList<String>();
        for (Player p : ((BukkitLoader)this.getCaller().getLoader()).getServer().getOnlinePlayers()) {
            list.add(p.getName());
        }
        return list;
    }

    @Override
    public boolean isOp(String playerName) {
        return ((BukkitLoader)this.getCaller().getLoader()).getServer().getOfflinePlayer(playerName).isOp();
    }

    @Override
    public UUID getUUID(String playerName) {
        return Bukkit.getPlayer((String)playerName).getUniqueId();
    }
}

