/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.com.zaxxer.libs.hikari.util;

import java.lang.reflect.Array;

public final class FastList<T> {
    private final Class<?> clazz;
    private T[] elementData;
    private int size;

    public FastList(Class<?> clazz) {
        this.elementData = (Object[])Array.newInstance(clazz, 32);
        this.clazz = clazz;
    }

    public FastList(Class<?> clazz, int capacity) {
        this.elementData = (Object[])Array.newInstance(clazz, capacity);
        this.clazz = clazz;
    }

    public void add(T element) {
        try {
            this.elementData[this.size++] = element;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int oldCapacity = this.elementData.length;
            int newCapacity = oldCapacity << 1;
            Object[] newElementData = (Object[])Array.newInstance(this.clazz, newCapacity);
            System.arraycopy(this.elementData, 0, newElementData, 0, oldCapacity);
            newElementData[this.size - 1] = element;
            this.elementData = newElementData;
        }
    }

    public T get(int index) {
        return this.elementData[index];
    }

    public T removeLast() {
        T element = this.elementData[--this.size];
        this.elementData[this.size] = null;
        return element;
    }

    public void remove(T element) {
        for (int index = this.size - 1; index >= 0; --index) {
            if (element != this.elementData[index]) continue;
            int numMoved = this.size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
            }
            this.elementData[--this.size] = null;
            break;
        }
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }
}

