/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.com.zaxxer.libs.hikari.pool;

import com.greatmancode.com.zaxxer.libs.hikari.pool.PoolBagEntry;
import com.greatmancode.libs.org.slf4j.Logger;
import com.greatmancode.libs.org.slf4j.LoggerFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class LeakTask
implements Runnable {
    public static final LeakTask NO_LEAK;
    private static final Logger LOGGER;
    private ScheduledExecutorService executorService;
    private long leakDetectionThreshold;
    private ScheduledFuture<?> scheduledFuture;
    private PoolBagEntry bagEntry;
    private Exception exception;

    public LeakTask(long leakDetectionThreshold, ScheduledExecutorService executorService) {
        this.executorService = executorService;
        this.leakDetectionThreshold = leakDetectionThreshold;
    }

    private LeakTask() {
    }

    private LeakTask(LeakTask parent, PoolBagEntry bagEntry) {
        this.exception = new Exception("Apparent connection leak detected");
        this.bagEntry = bagEntry;
        this.scheduledFuture = parent.executorService.schedule(this, parent.leakDetectionThreshold, TimeUnit.MILLISECONDS);
    }

    public LeakTask start(PoolBagEntry bagEntry) {
        return new LeakTask(this, bagEntry);
    }

    @Override
    public void run() {
        StackTraceElement[] stackTrace = this.exception.getStackTrace();
        StackTraceElement[] trace = new StackTraceElement[stackTrace.length - 5];
        System.arraycopy(stackTrace, 5, trace, 0, trace.length);
        this.exception.setStackTrace(trace);
        LOGGER.warn("Connection leak detection triggered for connection {}, stack trace follows", (Object)this.bagEntry.connection.toString(), (Object)this.exception);
    }

    public void cancel() {
        this.scheduledFuture.cancel(false);
    }

    static {
        LOGGER = LoggerFactory.getLogger(LeakTask.class);
        NO_LEAK = new LeakTask(){

            @Override
            public void cancel() {
            }

            @Override
            public LeakTask start(PoolBagEntry bagEntry) {
                return this;
            }
        };
    }
}

