/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.interfaces;

import com.greatmancode.craftconomy3.tools.ServerType;
import com.greatmancode.craftconomy3.tools.caller.sponge.SpongeServerCaller;
import com.greatmancode.craftconomy3.tools.commands.interfaces.CommandReceiver;
import com.greatmancode.craftconomy3.tools.events.EventManager;
import com.greatmancode.craftconomy3.tools.interfaces.Common;
import com.greatmancode.craftconomy3.tools.interfaces.Loader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.plugin.Plugin;

@Plugin(id="GreatmancodeToolsLoader", name="GreatmancodeToolsLoader", version="1.0")
public class SpongeLoader
implements Loader {
    private Game game;
    private EventManager eventManager;
    private Common common;

    @Listener
    public void preInitialisationEvent(GameStartedServerEvent event) {
        this.game = Sponge.getGame();
        this.onEnable();
    }

    @Listener
    public void onShutdown(GameStoppingServerEvent event) {
        this.onDisable();
    }

    @Override
    public void onEnable() {
        SpongeServerCaller serverCaller = new SpongeServerCaller(this, this.getClass().getAnnotation(Plugin.class).name(), this.getClass().getAnnotation(Plugin.class).version());
        this.eventManager = new EventManager(serverCaller);
        InputStream is = this.getClass().getResourceAsStream("/loader.yml");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String mainClass = br.readLine();
            mainClass = mainClass.split("main-class:")[1].trim();
            Class<?> clazz = Class.forName(mainClass);
            if (Common.class.isAssignableFrom(clazz)) {
                this.common = (Common)clazz.newInstance();
                this.common.onEnable(serverCaller, serverCaller.getLogger());
                String name = br.readLine().split("name:")[1].trim();
                String version = br.readLine().split("version:")[1].trim();
            } else {
                serverCaller.getLogger().severe("The class " + mainClass + " is invalid!");
            }
        }
        catch (IOException e) {
            serverCaller.getLogger().log(Level.SEVERE, "Unable to load the main class!", e);
        }
        catch (ClassNotFoundException e) {
            serverCaller.getLogger().log(Level.SEVERE, "Unable to load the main class!", e);
        }
        catch (InstantiationException e) {
            serverCaller.getLogger().log(Level.SEVERE, "Unable to load the main class!", e);
        }
        catch (IllegalAccessException e) {
            serverCaller.getLogger().log(Level.SEVERE, "Unable to load the main class!", e);
        }
    }

    @Override
    public void onDisable() {
    }

    @Override
    public ServerType getServerType() {
        return ServerType.SPONGE;
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public Common getCommon() {
        return this.common;
    }

    @Override
    public CommandReceiver getCommandReceiver() {
        return null;
    }

    @Override
    public void setCommandReceiver(CommandReceiver receiver) {
    }

    public Game getGame() {
        return this.game;
    }
}

