/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.commands;

import com.greatmancode.craftconomy3.tools.caller.bukkit.BukkitServerCaller;
import com.greatmancode.craftconomy3.tools.commands.SubCommand;
import com.greatmancode.craftconomy3.tools.commands.bukkit.BukkitCommandReceiver;
import com.greatmancode.craftconomy3.tools.commands.interfaces.CommandReceiver;
import com.greatmancode.craftconomy3.tools.interfaces.caller.ServerCaller;
import java.util.HashMap;
import java.util.Map;

public class CommandHandler {
    private ServerCaller serverCaller;
    private CommandReceiver commandReceiver;
    private Map<String, SubCommand> commandList = new HashMap<String, SubCommand>();
    private int currentLevel = 0;
    private String wrongLevelMsg = "Wrong level!";

    public CommandHandler(ServerCaller serverCaller) {
        this.serverCaller = serverCaller;
        if (this.serverCaller instanceof BukkitServerCaller) {
            this.commandReceiver = new BukkitCommandReceiver(this);
        }
        serverCaller.getLoader().setCommandReceiver(this.commandReceiver);
    }

    public CommandHandler registerMainCommand(String name, SubCommand subCommand) {
        this.commandList.put(name, subCommand);
        this.serverCaller.addCommand(name, "", subCommand);
        return this;
    }

    public SubCommand getCommand(String name) {
        return this.commandList.get(name);
    }

    public ServerCaller getServerCaller() {
        return this.serverCaller;
    }

    public CommandReceiver getCommandReceiver() {
        return this.commandReceiver;
    }

    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public String getWrongLevelMsg() {
        return this.wrongLevelMsg;
    }

    public void setWrongLevelMsg(String wrongLevelMsg) {
        this.wrongLevelMsg = wrongLevelMsg;
    }
}

