/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.converter.converters;

import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.converter.Converter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Essentials
extends Converter {
    public Essentials() {
        this.getDbTypes().add("flatfile");
    }

    @Override
    public List<String> getDbInfo() {
        return new ArrayList<String>();
    }

    @Override
    public boolean connect() {
        return true;
    }

    @Override
    public boolean importData(String sender) {
        File accountsFolder = new File("plugins/Essentials/userdata/");
        if (!accountsFolder.isDirectory()) {
            return false;
        }
        File[] accounts = accountsFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.toLowerCase().endsWith(".yml");
            }
        });
        ArrayList<Converter.User> userList = new ArrayList<Converter.User>();
        Common.getInstance().getLogger().info("Amount of accounts found:" + accounts.length);
        int i = 0;
        for (File account : accounts) {
            String uuid = null;
            String name = null;
            double money = 0.0;
            boolean haveMoney = false;
            if (account.getName().contains("-")) {
                uuid = account.getName().replace(".yml", "");
            }
            try {
                BufferedReader reader = new BufferedReader(new FileReader(account));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("money:")) {
                            String value = line.replace("money: '", "");
                            if (value.contains("money")) {
                                value = line.replace("money: ", "");
                            }
                            money = Double.parseDouble(value.substring(0, value.length() - 1));
                            haveMoney = true;
                            continue;
                        }
                        if (!line.startsWith("lastAccountName:")) continue;
                        name = line.replace("lastAccountName: ", "").trim().replace("'", "").replace("\"", "");
                    }
                }
                catch (NumberFormatException e) {
                    Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_RED}}The account " + uuid + " don't have a valid money value!");
                }
                if (haveMoney) {
                    userList.add(new Converter.User(name, uuid, money));
                }
                if (i % 10 == 0) {
                    Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, i + " {{DARK_GREEN}}accounts loaded.");
                }
                ++i;
                reader.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.addAccountToString(sender, userList);
        return true;
    }
}

